package com.bizunited.empower.business.product.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


@ApiModel(value = "ProductFileVo", description = "商品文件")
public class ProductFileVo extends TenantOpVo {

  /**
   * 
   */
  private static final long serialVersionUID = 8289185776153698398L;

  /** 商品编号 */
  @ApiModelProperty("商品编号")
  private String productCode;

  /** 商品 */
  private ProductVo product;

  /** 相对路径 */
  @ApiModelProperty("相对路径")
  private String relativePath;

  /** 文件名 */
  @ApiModelProperty("文件名")
  private String fileName;

  /**
   * 图片资源库
   */
  @ApiModelProperty("图片资源")
  private ProductImageResourceVo productImageResource;

  /** 图片类型 */
  @ApiModelProperty("图片类型")
  private String type;

  /**
   * 是主图
   */
  @ApiModelProperty("是主图")
  @JsonProperty(value = "isMainImage")
  private Boolean isMainImage;

  /**
   * 排序（按数字顺序排列）
   */
  @ApiModelProperty("排序（按数字顺序排列）")
  private Integer sortIndex;

  public Boolean getMainImage() {
    return isMainImage;
  }

  public void setMainImage(Boolean mainImage) {
    isMainImage = mainImage;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public ProductVo getProduct() {
    return product;
  }

  public void setProduct(ProductVo product) {
    this.product = product;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ProductImageResourceVo getProductImageResource() {
    return productImageResource;
  }

  public void setProductImageResource(ProductImageResourceVo productImageResource) {
    this.productImageResource = productImageResource;
  }
}
