package com.bizunited.empower.business.product.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 商品图片资源库
 * @author lihuan
 */
@ApiModel(value = "ProductImageResource", description = "商品图片资源库")
public class ProductImageResourceVo extends TenantOpVo {
  private static final long serialVersionUID = -3812650648504285177L;

  /** 商品编号 */
  @ApiModelProperty("商品编号")
  private ProductVo product;

  /** 相对路径 */
  @ApiModelProperty("相对路径")
  private String relativePath;

  /** 文件名 */
  @ApiModelProperty("文件名")
  private String fileName;

  /** 图片类型 */
  @ApiModelProperty("图片类型")
  private String type;

  /**
   * 是否使用图片
   */
  @ApiModelProperty(name = "required", value = "是否使用图片：false否，true是", required = true)
  private Boolean useImage;

  public ProductVo getProduct() {
    return product;
  }

  public void setProduct(ProductVo product) {
    this.product = product;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Boolean getUseImage() {
    return useImage;
  }

  public void setUseImage(Boolean useImage) {
    this.useImage = useImage;
  }
}