package com.bizunited.empower.business.product.vo;

import io.swagger.annotations.ApiModel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 营销活动信息
 *
 * @author Keller
 */
@ApiModel(value = "ProductPreferentialItemVo", description = "营销活动信息")
public class ProductPreferentialItemVo implements Serializable {

  private static final long serialVersionUID = 5210080781891151624L;
  /**
   * 营销活动名称
   */
  private String name;

  /**
   * 营销活动编号
   */
  private String code;

  /**
   * 营销活动标签
   */
  private String tag;

  /**
   * 营销活动内容
   */
  private String description;

  /**
   * 营销活动开始时间
   */
  private Date validStartTime;

  /**
   * 营销活动结束时间
   */
  private Date validEndTime;

  /**
   * 在“特价”营销活动时设定的指定价格
   */
  private BigDecimal specificPrice;

  /**
   * 营销活动标签值
   */
  private String label;

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getTag() {
    return tag;
  }

  public void setTag(String tag) {
    this.tag = tag;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Date getValidStartTime() {
    return validStartTime;
  }

  public void setValidStartTime(Date validStartTime) {
    this.validStartTime = validStartTime;
  }

  public Date getValidEndTime() {
    return validEndTime;
  }

  public void setValidEndTime(Date validEndTime) {
    this.validEndTime = validEndTime;
  }

  public BigDecimal getSpecificPrice() {
    return specificPrice;
  }

  public void setSpecificPrice(BigDecimal specificPrice) {
    this.specificPrice = specificPrice;
  }

  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }
}
