package com.bizunited.empower.business.product.vo;

import com.bizunited.empower.business.customer.vo.CustomerCategoryVo;
import com.bizunited.empower.business.customer.vo.SalesAreaVo;
import com.bizunited.platform.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

@ApiModel(value = "ProductPricingVo", description = "商品定价")
public class ProductPricingVo extends TenantOpVo {

  /**
   * 
   */
  private static final long serialVersionUID = 8938807670790119391L;

  /** 商品编码 */
  @ApiModelProperty("商品编码")
  private String productCode;

  /** 商品 */
  private ProductVo product;

  /**
   * 规格
   */
  private ProductSpecificationVo productSpecification;

  /** 客户级别 */
  @ApiModelProperty("客户级别")
  private String customerLevel;

  /** 级别名称 */
  @ApiModelProperty("级别名称")
  private String levelName;

  /** 客户编码 */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /** 客户名称 */
  @ApiModelProperty("客户名称")
  private String customerName;

  /** 是客户编码 */
  @ApiModelProperty("是客户编码")
  private Boolean isCustomerCode;

  /**
   * 产品定价按单位定价
   */
  @ApiModelProperty("产品定价按单位定价")
  private Set<ProductPricingUnitSpecificationVo> productPricingUnitSpecifications;

  /**
   * 客户分类
   */
  @ApiModelProperty("客户分类")
  private CustomerCategoryVo customerCategory;

  /**
   * 销售区域
   */
  @ApiModelProperty("销售区域")
  private SalesAreaVo salesArea;

  public String getLevelName() {
    return levelName;
  }

  public void setLevelName(String levelName) {
    this.levelName = levelName;
  }

  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  public Set<ProductPricingUnitSpecificationVo> getProductPricingUnitSpecifications() {
    return productPricingUnitSpecifications;
  }

  public void setProductPricingUnitSpecifications(Set<ProductPricingUnitSpecificationVo> productPricingUnitSpecifications) {
    this.productPricingUnitSpecifications = productPricingUnitSpecifications;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public ProductVo getProduct() {
    return product;
  }

  public void setProduct(ProductVo product) {
    this.product = product;
  }

  public String getCustomerLevel() {
    return customerLevel;
  }

  public void setCustomerLevel(String customerLevel) {
    this.customerLevel = customerLevel;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(Boolean customerCode) {
    isCustomerCode = customerCode;
  }

  public Boolean getIsCustomerCode(){
    return this.isCustomerCode;
  }

  public void setIsCustomerCode(Boolean isCustomerCode){
    this.isCustomerCode = isCustomerCode;
  }


  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public ProductSpecificationVo getProductSpecification() {
    return productSpecification;
  }

  public void setProductSpecification(ProductSpecificationVo productSpecification) {
    this.productSpecification = productSpecification;
  }

  public CustomerCategoryVo getCustomerCategory() {
    return customerCategory;
  }

  public void setCustomerCategory(CustomerCategoryVo customerCategory) {
    this.customerCategory = customerCategory;
  }

  public SalesAreaVo getSalesArea() {
    return salesArea;
  }

  public void setSalesArea(SalesAreaVo salesArea) {
    this.salesArea = salesArea;
  }
}
