package com.bizunited.empower.business.product.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

@ApiModel(value = "ProductShowCategoryVo", description = "商品前端展示分类")
public class ProductShowCategoryVo extends TenantOpVo {
  private static final long serialVersionUID = 1509588360599202533L;


  /** 分类名称 */
  @ApiModelProperty("分类名称")
  private String name;

  /** 分类编码 */
  @ApiModelProperty("分类编码")
  private String code;

  /** 层级 */
  @ApiModelProperty("层级")
  private Integer level;

  /** 父级编号 */
  @ApiModelProperty("父级编号")
  private String parentCode;

  /** 快速编号 */
  @ApiModelProperty("快速编号")
  private String flatCode;

  /** 商品信息 */
  @ApiModelProperty("商品信息")
  private Set<ProductVo> products;

  private Set<ProductShowCategoryVo> children;

  public Set<ProductShowCategoryVo> getChildren() {
    return children;
  }

  public void setChildren(Set<ProductShowCategoryVo> children) {
    this.children = children;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getFlatCode() {
    return flatCode;
  }

  public void setFlatCode(String flatCode) {
    this.flatCode = flatCode;
  }

  public Set<ProductVo> getProducts() {
    return products;
  }

  public void setProducts(Set<ProductVo> products) {
    this.products = products;
  }
}
