package com.bizunited.empower.business.product.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Set;

@ApiModel(value = "ProductSpecificationVo", description = "商品规格")
public class ProductSpecificationVo extends TenantOpVo {

  /**
   * 
   */
  private static final long serialVersionUID = -8138432178111911966L;

  /** 商品编号 */
  @ApiModelProperty("商品编号")
  private String productCode;

  /** 商品 */
  private ProductVo product;

  /** 规格编号 */
  @ApiModelProperty("规格编号")
  private String productSpecificationCode;

  /** 规格名称 */
  @ApiModelProperty("规格名称")
  private String productSpecificationName;

  /** 优惠项目 */
  @ApiModelProperty("优惠项目")
  private Set<ProductPreferentialItemVo> preferentialItems;

  /** 起订量 */
  @ApiModelProperty("起订量")
  private BigDecimal minimumOrderQuantity;

  /** 限定量 */
  @ApiModelProperty("限定量")
  private BigDecimal maximumOrderQuantity;

  /** 主图路径 */
  @ApiModelProperty("主图路径")
  private String mainImagePath;

  /** 主图名称 */
  @ApiModelProperty("主图名称")
  private String mainImageName;

  /** 仓库编码 */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /** 条形码 */
  @ApiModelProperty("条形码")
  private Set<ProductBarCodeInfoVo> productBarCodeInfos;

  /**
   * 基本单位
   */
  @ApiModelProperty("基本单位")
  private ProductUnitVo basicUnit;

  @ApiModelProperty("规格客户定价")
  private Set<ProductPricingVo> productPricings;

  @ApiModelProperty("规格价格")
  private Set<ProductUnitSpecificationAndPriceVo> productUnitSpecificationAndPrices;


  /**
   * 可用库存信息
   */
  @ApiModelProperty("可用库存量（后四位是小数的转换）")
  private BigDecimal usableInventory;

  /**
   * 实际库存信息
   */
  @ApiModelProperty("实际库存信息")
  private BigDecimal inventory;

  /**
   * 图片资源库
   */
  @ApiModelProperty("图片资源")
  private ProductImageResourceVo productImageResource;

  public BigDecimal getInventory() {
    return inventory;
  }

  public void setInventory(BigDecimal inventory) {
    this.inventory = inventory;
  }

  public BigDecimal getUsableInventory() {
    return usableInventory;
  }

  public void setUsableInventory(BigDecimal usableInventory) {
    this.usableInventory = usableInventory;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public ProductVo getProduct() {
    return product;
  }

  public void setProduct(ProductVo product) {
    this.product = product;
  }

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }

  public BigDecimal getMinimumOrderQuantity() {
    return minimumOrderQuantity;
  }

  public void setMinimumOrderQuantity(BigDecimal minimumOrderQuantity) {
    this.minimumOrderQuantity = minimumOrderQuantity;
  }

  public BigDecimal getMaximumOrderQuantity() {
    return maximumOrderQuantity;
  }

  public void setMaximumOrderQuantity(BigDecimal maximumOrderQuantity) {
    this.maximumOrderQuantity = maximumOrderQuantity;
  }

  public String getMainImagePath() {
    return mainImagePath;
  }

  public void setMainImagePath(String mainImagePath) {
    this.mainImagePath = mainImagePath;
  }

  public String getMainImageName() {
    return mainImageName;
  }

  public void setMainImageName(String mainImageName) {
    this.mainImageName = mainImageName;
  }

  public String getWarehouseCode() {
    return warehouseCode;
  }

  public void setWarehouseCode(String warehouseCode) {
    this.warehouseCode = warehouseCode;
  }

  public Set<ProductBarCodeInfoVo> getProductBarCodeInfos() {
    return productBarCodeInfos;
  }

  public void setProductBarCodeInfos(Set<ProductBarCodeInfoVo> productBarCodeInfos) {
    this.productBarCodeInfos = productBarCodeInfos;
  }

  public ProductUnitVo getBasicUnit() {
    return basicUnit;
  }

  public void setBasicUnit(ProductUnitVo basicUnit) {
    this.basicUnit = basicUnit;
  }

  public Set<ProductPreferentialItemVo> getPreferentialItems() {
    return preferentialItems;
  }

  public void setPreferentialItems(Set<ProductPreferentialItemVo> preferentialItems) {
    this.preferentialItems = preferentialItems;
  }

  public Set<ProductPricingVo> getProductPricings() {
    return productPricings;
  }

  public void setProductPricings(Set<ProductPricingVo> productPricings) {
    this.productPricings = productPricings;
  }

  public Set<ProductUnitSpecificationAndPriceVo> getProductUnitSpecificationAndPrices() {
    return productUnitSpecificationAndPrices;
  }

  public void setProductUnitSpecificationAndPrices(Set<ProductUnitSpecificationAndPriceVo> productUnitSpecificationAndPrices) {
    this.productUnitSpecificationAndPrices = productUnitSpecificationAndPrices;
  }

  public ProductImageResourceVo getProductImageResource() {
    return productImageResource;
  }

  public void setProductImageResource(ProductImageResourceVo productImageResource) {
    this.productImageResource = productImageResource;
  }
}
