package com.bizunited.empower.business.product.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

@ApiModel(value = "ProductTagVo", description = "商品标签")
public class ProductTagVo extends TenantOpVo{

  /**
   * 
   */
  private static final long serialVersionUID = -4422270669655744280L;

  /** 标签名 */
  @ApiModelProperty("标签名")
  private String tagName;

  /** 标签编号 */
  @ApiModelProperty("标签编号")
  private String tagCode;

  /** 层级 */
  @ApiModelProperty("层级")
  private Integer level;

  /** 父级 */
  @ApiModelProperty("父级")
  private String parentCode;

  /** 快速编号 */
  @ApiModelProperty("快速编号")
  private String flatCode;

  /** 禁用状态 */
  @ApiModelProperty(name="tstatus" , value="状态 1正常, 0禁用." , required=true)
  private Integer tstatus;

  /** 商品信息 */
  @ApiModelProperty("商品信息")
  private Set<ProductVo> products;

  public String getTagName() {
    return tagName;
  }

  public void setTagName(String tagName) {
    this.tagName = tagName;
  }

  public String getTagCode() {
    return tagCode;
  }

  public void setTagCode(String tagCode) {
    this.tagCode = tagCode;
  }

  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getFlatCode() {
    return flatCode;
  }

  public void setFlatCode(String flatCode) {
    this.flatCode = flatCode;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Set<ProductVo> getProducts() {
    return products;
  }

  public void setProducts(Set<ProductVo> products) {
    this.products = products;
  }
}
