package com.bizunited.empower.business.product.vo;

import com.bizunited.platform.common.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

@ApiModel(value = "ProductUnitAndPriceVo", description = "商品单位与价格")
public class ProductUnitAndPriceVo extends TenantVo {

  /**
   * 
   */
  private static final long serialVersionUID = -1597957705004988510L;

  /** 商品编码 */
  @ApiModelProperty("商品编码")
  private String productCode;

  /** 商品 */
  private ProductVo product;

  /** 单位编号 */
  @ApiModelProperty("单位编号")
  private String unitCode;

  /** 单位 */
  private ProductUnitVo productUnit;

  /** 是基本单位 */
  @ApiModelProperty("是基本单位")
  private Boolean isBasicUnit;

  /** 允许购买 */
  @ApiModelProperty("允许购买")
  private Boolean allowPurchase;

  /** 默认购买 */
  @ApiModelProperty("默认购买")
  private Boolean defaultPurchase;

  /** 换算比例 */
  @ApiModelProperty("换算比例")
  private BigDecimal conversionRatio;

  /** 参考进货价 */
  @ApiModelProperty("参考进货价")
  private BigDecimal referencePurchasePrice;

  /** 销售价 */
  @ApiModelProperty("销售价")
  private BigDecimal sellingPrice;

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public ProductVo getProduct() {
    return product;
  }

  public void setProduct(ProductVo product) {
    this.product = product;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public ProductUnitVo getProductUnit() {
    return productUnit;
  }

  public void setProductUnit(ProductUnitVo productUnit) {
    this.productUnit = productUnit;
  }

  public Boolean getBasicUnit() {
    return isBasicUnit;
  }

  public void setBasicUnit(Boolean basicUnit) {
    isBasicUnit = basicUnit;
  }

  public Boolean getAllowPurchase() {
    return allowPurchase;
  }

  public void setAllowPurchase(Boolean allowPurchase) {
    this.allowPurchase = allowPurchase;
  }

  public Boolean getDefaultPurchase() {
    return defaultPurchase;
  }

  public void setDefaultPurchase(Boolean defaultPurchase) {
    this.defaultPurchase = defaultPurchase;
  }

  public BigDecimal getConversionRatio() {
    return conversionRatio;
  }

  public void setConversionRatio(BigDecimal conversionRatio) {
    this.conversionRatio = conversionRatio;
  }

  public BigDecimal getReferencePurchasePrice() {
    return referencePurchasePrice;
  }

  public void setReferencePurchasePrice(BigDecimal referencePurchasePrice) {
    this.referencePurchasePrice = referencePurchasePrice;
  }

  public BigDecimal getSellingPrice() {
    return sellingPrice;
  }

  public void setSellingPrice(BigDecimal sellingPrice) {
    this.sellingPrice = sellingPrice;
  }
}
