package com.bizunited.empower.business.product.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Set;

@ApiModel(value = "ProductVo", description = "商品")
public class ProductVo extends TenantOpVo {

  /**
   * 
   */
  private static final long serialVersionUID = 231441893967898877L;

  /** 商品编码 */
  @ApiModelProperty("商品编码")
  private String productCode;

  /** 商品名称 */
  @ApiModelProperty("商品名称")
  private String productName;

  /** 分类编码 */
  @ApiModelProperty("分类编码")
  private String categoryCode;

  /** 分类 */
  @ApiModelProperty("分类")
  private ProductCategoryVo productCategory;

  @ApiModelProperty("前端分类")
  private ProductShowCategoryVo productShowCategory;

  /** 品牌编码 */
  @ApiModelProperty("品牌编码")
  private String brandCode;

  /** 品牌 */
  @ApiModelProperty("品牌")
  private ProductBrandVo productBrand;

  /** 上架状态 */
  @ApiModelProperty("上架状态：1，立即上架；2，暂不上架")
  private Integer shelfStatus;

  /** 默认仓库 */
  @ApiModelProperty("默认仓库")
  private String defaultWarehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /** 搜索关键字 */
  @ApiModelProperty("搜索关键字")
  private String searchKeyword;

  /** 备注信息 */
  @ApiModelProperty("备注信息")
  private String remark;

  /** 优惠项目 */
  @ApiModelProperty("优惠项目")
  private Set<ProductPreferentialItemVo> preferentialItems;

  /** 商品文件 */
  @ApiModelProperty("商品文件")
  private Set<ProductFileVo> productFiles;

  /** 商品规格 */
  @ApiModelProperty("商品规格")
  private Set<ProductSpecificationVo> productSpecifications;

  /** 商品多规格参数 */
  @ApiModelProperty("商品多规格参数")
  private Set<ProductMultipleSpecificationVo> productMultipleSpecifications;

  /** 商品标签 */
  @ApiModelProperty("商品标签")
  private Set<ProductTagVo> tags;

  /** 商品价格 */
  @ApiModelProperty("商品价格")
  private Set<ProductPricingVo> productPricings;

  /** 单位规格与价格 */
  @ApiModelProperty("单位规格与价格")
  private Set<ProductUnitSpecificationAndPriceVo> productUnitSpecificationAndPrices;

  /** 单位与价格 */
  @ApiModelProperty("单位与价格")
  private Set<ProductUnitAndPriceVo> productUnitAndPrices;

  /** 基本单位的建议销售价 */
  @ApiModelProperty("基本单位的建议销售价")
  @Transient
  private BigDecimal baseUnitSellPrice;

  /**
   * 可用库存信息
   */
  @ApiModelProperty("可用库存量（后四位是小数的转换）")
  private BigDecimal usableInventory;

  /**
   * 商品配图状态
   */
  @ApiModelProperty("商品配图状态：1，未完善；2，已完善")
  private Integer productImageStatus;

  /**
   * 规格配图状态
   */
  @ApiModelProperty("规格配图状态：1，待配图；2，完成配图")
  private Integer specificationImageStatus;

  /**
   * 商品图片资源库
   */
  @ApiModelProperty("商品图片资源库")
  private Set<ProductImageResourceVo> productImageResources;

  /**
   * 图库图片总数量
   */
  @ApiModelProperty("图库图片总数量")
  private Integer imageResourceCount;

  /**
   * 规格数量
   */
  @ApiModelProperty("规格数量")
  private Integer specificationCount;

  /**
   * 规格配图数量
   */
  @ApiModelProperty("规格配图数量")
  private Integer specificationImageResourceCount;

  public BigDecimal getUsableInventory() {
    return usableInventory;
  }

  public void setUsableInventory(BigDecimal usableInventory) {
    this.usableInventory = usableInventory;
  }

  public String getWarehouseName() {
    return warehouseName;
  }

  public void setWarehouseName(String warehouseName) {
    this.warehouseName = warehouseName;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public String getCategoryCode() {
    return categoryCode;
  }

  public void setCategoryCode(String categoryCode) {
    this.categoryCode = categoryCode;
  }

  public ProductCategoryVo getProductCategory() {
    return productCategory;
  }

  public void setProductCategory(ProductCategoryVo productCategory) {
    this.productCategory = productCategory;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }

  public ProductBrandVo getProductBrand() {
    return productBrand;
  }

  public void setProductBrand(ProductBrandVo productBrand) {
    this.productBrand = productBrand;
  }

  public Integer getShelfStatus() {
    return shelfStatus;
  }

  public void setShelfStatus(Integer shelfStatus) {
    this.shelfStatus = shelfStatus;
  }

  public String getDefaultWarehouseCode() {
    return defaultWarehouseCode;
  }

  public void setDefaultWarehouseCode(String defaultWarehouseCode) {
    this.defaultWarehouseCode = defaultWarehouseCode;
  }

  public String getSearchKeyword() {
    return searchKeyword;
  }

  public void setSearchKeyword(String searchKeyword) {
    this.searchKeyword = searchKeyword;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Set<ProductFileVo> getProductFiles() {
    return productFiles;
  }

  public void setProductFiles(Set<ProductFileVo> productFiles) {
    this.productFiles = productFiles;
  }

  public Set<ProductSpecificationVo> getProductSpecifications() {
    return productSpecifications;
  }

  public void setProductSpecifications(Set<ProductSpecificationVo> productSpecifications) {
    this.productSpecifications = productSpecifications;
  }

  public Set<ProductMultipleSpecificationVo> getProductMultipleSpecifications() {
    return productMultipleSpecifications;
  }

  public void setProductMultipleSpecifications(Set<ProductMultipleSpecificationVo> productMultipleSpecifications) {
    this.productMultipleSpecifications = productMultipleSpecifications;
  }

  public Set<ProductTagVo> getTags() {
    return tags;
  }

  public void setTags(Set<ProductTagVo> tags) {
    this.tags = tags;
  }

  public Set<ProductPricingVo> getProductPricings() {
    return productPricings;
  }

  public void setProductPricings(Set<ProductPricingVo> productPricings) {
    this.productPricings = productPricings;
  }

  public Set<ProductUnitSpecificationAndPriceVo> getProductUnitSpecificationAndPrices() {
    return productUnitSpecificationAndPrices;
  }

  public void setProductUnitSpecificationAndPrices(Set<ProductUnitSpecificationAndPriceVo> productUnitSpecificationAndPrices) {
    this.productUnitSpecificationAndPrices = productUnitSpecificationAndPrices;
  }

  public BigDecimal getBaseUnitSellPrice() {
    return baseUnitSellPrice;
  }

  public void setBaseUnitSellPrice(BigDecimal baseUnitSellPrice) {
    this.baseUnitSellPrice = baseUnitSellPrice;
  }

  public Set<ProductPreferentialItemVo> getPreferentialItems() {
    return preferentialItems;
  }

  public void setPreferentialItems(Set<ProductPreferentialItemVo> preferentialItems) {
    this.preferentialItems = preferentialItems;
  }

  public Set<ProductUnitAndPriceVo> getProductUnitAndPrices() {
    return productUnitAndPrices;
  }

  public void setProductUnitAndPrices(Set<ProductUnitAndPriceVo> productUnitAndPrices) {
    this.productUnitAndPrices = productUnitAndPrices;
  }

  public ProductShowCategoryVo getProductShowCategory() {
    return productShowCategory;
  }

  public void setProductShowCategory(ProductShowCategoryVo productShowCategory) {
    this.productShowCategory = productShowCategory;
  }

  public Integer getProductImageStatus() {
    return productImageStatus;
  }

  public void setProductImageStatus(Integer productImageStatus) {
    this.productImageStatus = productImageStatus;
  }

  public Integer getSpecificationImageStatus() {
    return specificationImageStatus;
  }

  public void setSpecificationImageStatus(Integer specificationImageStatus) {
    this.specificationImageStatus = specificationImageStatus;
  }

  public Set<ProductImageResourceVo> getProductImageResources() {
    return productImageResources;
  }

  public void setProductImageResources(Set<ProductImageResourceVo> productImageResources) {
    this.productImageResources = productImageResources;
  }

  public Integer getImageResourceCount() {
    return imageResourceCount;
  }

  public void setImageResourceCount(Integer imageResourceCount) {
    this.imageResourceCount = imageResourceCount;
  }

  public Integer getSpecificationCount() {
    return specificationCount;
  }

  public void setSpecificationCount(Integer specificationCount) {
    this.specificationCount = specificationCount;
  }

  public Integer getSpecificationImageResourceCount() {
    return specificationImageResourceCount;
  }

  public void setSpecificationImageResourceCount(Integer specificationImageResourceCount) {
    this.specificationImageResourceCount = specificationImageResourceCount;
  }
}
