package com.bizunited.empower.business.product.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Set;

@ApiModel(value = "SaasProductCategoryVo", description = "商品分类")
public class SaasProductCategoryVo implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = -1007837678128225371L;

  /**
   * 分类名称
   */
  @ApiModelProperty("分类名称")
  private String name;

  /**
   * 分类编码
   */
  @ApiModelProperty("分类编码")
  private String code;

  /**
   * 层级
   */
  @ApiModelProperty("层级")
  private Integer level;

  /**
   * 父级编号
   */
  @ApiModelProperty("父级编号")
  private String parentCode;

  /**
   * 快速编号
   */
  @ApiModelProperty("快速编号")
  private String flatCode;

  /**
   * 全量名称
   */
  @ApiModelProperty("全量名称")
  private String flatName;

  /**
   * 商品信息
   */
  @ApiModelProperty("商品信息")
  private Set<SaasProductVo> products;

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getFlatCode() {
    return flatCode;
  }

  public void setFlatCode(String flatCode) {
    this.flatCode = flatCode;
  }

  public Set<SaasProductVo> getProducts() {
    return products;
  }

  public void setProducts(Set<SaasProductVo> products) {
    this.products = products;
  }

  public String getFlatName() {
    return flatName;
  }

  public void setFlatName(String flatName) {
    this.flatName = flatName;
  }
}