package com.bizunited.empower.business.product.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;

@ApiModel(value = "SaasProductVo", description = "商品信息")
public class SaasProductVo implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = 1826078462100696721L;

  /** 条形码 */
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 厂商
   */
  @ApiModelProperty("厂商")
  private String manuName;

  /**
   * 规格名称
   */
  @ApiModelProperty("规格名称")
  private String productSpecificationName;

  /** 订货价格 */
  @ApiModelProperty("参考价格")
  private BigDecimal price;

  /**
   * 品牌
   */
  @ApiModelProperty("品牌")
  private SaasProductBrandVo productBrand;


  /**
   * 商品文件
   */
  @ApiModelProperty("商品文件")
  private Set<SaasProductFileVo> productFiles;

  /**
   * 商品分类
   */
  @ApiModelProperty("商品分类")
  private SaasProductCategoryVo productCategory;

  /**
   * 原产地
   */
  @ApiModelProperty("原产地")
  private String ycg;

  /**
   * 备注信息
   */
  @ApiModelProperty("备注信息")
  private String note;

  /**
   * 厂商地址
   */
  @ApiModelProperty("厂商地址")
  private String manuAddress;


  public String getBarCode() {
    return barCode;
  }

  public void setBarCode(String barCode) {
    this.barCode = barCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public String getManuName() {
    return manuName;
  }

  public void setManuName(String manuName) {
    this.manuName = manuName;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }

  public BigDecimal getPrice() {
    return price;
  }

  public void setPrice(BigDecimal price) {
    this.price = price;
  }

  public SaasProductBrandVo getProductBrand() {
    return productBrand;
  }

  public void setProductBrand(SaasProductBrandVo productBrand) {
    this.productBrand = productBrand;
  }

  public Set<SaasProductFileVo> getProductFiles() {
    return productFiles;
  }

  public void setProductFiles(Set<SaasProductFileVo> productFiles) {
    this.productFiles = productFiles;
  }

  public SaasProductCategoryVo getProductCategory() {
    return productCategory;
  }

  public void setProductCategory(SaasProductCategoryVo productCategory) {
    this.productCategory = productCategory;
  }

  public String getYcg() {
    return ycg;
  }

  public void setYcg(String ycg) {
    this.ycg = ycg;
  }

  public String getNote() {
    return note;
  }

  public void setNote(String note) {
    this.note = note;
  }

  public String getManuAddress() {
    return manuAddress;
  }

  public void setManuAddress(String manuAddress) {
    this.manuAddress = manuAddress;
  }
}
