package com.bizunited.empower.business.purchase.common.enums;

/**
 * 采购单付款状态
 * @author lihuan
 */
public enum PurchaseOrderPayStatus {
  /**
   * 采购单状态
   */
  OBLIGATION(0,"待付款"),
  PARTIAL_PAYMENT(1,"部分付款"),
  ACCOUNT_PAID(2,"已付款"),
  CANCELED(3,"已取消")
  ;

  /**
   * 状态
   */
  private Integer code;
  /**
   * 描述
   */
  private String desc;

  PurchaseOrderPayStatus(Integer code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public Integer getCode() {
    return code;
  }

  public String getDesc() {
    return desc;
  }
}
