package com.bizunited.empower.business.purchase.common.enums;

/**
 * 采购订单状态
 * @author lihuan
 */
public enum PurchaseOrderStatus {
  /**
   * 采购单状态
   */
  TO_AUDIT(0,"待审核"),
  STOCK_PENDING(1,"待入库"),
  PART_WAREHOUSE(2,"部分入库"),
  COMPLETED(3,"已完成"),
  CANCELED(4,"已取消")
  ;

  /**
   * 状态
   */
  private Integer code;

  /**
   * 描述
   */
  private String desc;

  PurchaseOrderStatus(Integer code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public Integer getCode() {
    return code;
  }

  public String getDesc() {
    return desc;
  }
}
