package com.bizunited.empower.business.purchase.controller;

import com.bizunited.empower.business.purchase.entity.Supplier;
import com.bizunited.empower.business.purchase.service.SupplierService;
import com.bizunited.empower.business.purchase.vo.SupplierVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.lang.String;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Supplier业务模型的MVC Controller层实现，基于HTTP Restful风格
 *
 * @author saturn
 */
@RestController
@RequestMapping("/v1/supplier")
public class SupplierController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(SupplierController.class);

  @Autowired
  private SupplierService supplierService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建supplier中的基本信息以外，还可以对supplier中属于OneToMany关联的明细信息一同进行创建注意：基于（Supplier）模型的创建操作传入的supplierJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建supplier中的基本信息以外，还可以对supplier中属于OneToMany关联的明细信息一同进行创建注意：基于（Supplier）模型的创建操作传入的supplierJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value = "")
  public ResponseModel create(@RequestBody @ApiParam(name = "supplier", value = "相关的创建过程，http接口。请注意该创建过程除了可以创建supplier中的基本信息以外，还可以对supplier中属于OneToMany关联的明细信息一同进行创建注意：基于（Supplier）模型的创建操作传入的supplierJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") Supplier supplier) {
    try {
      Supplier current = this.supplierService.create(supplier);
      return this.buildHttpResultW(current, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（Supplier）的修改操作传入的supplierJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（Supplier）的修改操作传入的supplierJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value = "")
  public ResponseModel update(@RequestBody @ApiParam(name = "supplier", value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（Supplier）的修改操作传入的supplierJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") Supplier supplier) {
    try {
      Supplier current = this.supplierService.update(supplier);
      return this.buildHttpResultW(current, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value = "/{id}")
  public ResponseModel findById(@PathVariable("id") @ApiParam(name = "id", value = "主键") String id) {
    try {
      Supplier current = this.supplierService.findById(id);
      return this.buildHttpResultW(current, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @DeleteMapping(value = "/{id}")
  public ResponseModel deleteById(@PathVariable("id") @ApiParam(name = "id", value = "主键") String id) {
    try {
      this.supplierService.deleteById(id);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照Supplier实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param id 主键
   */
  @ApiOperation(value = "按照Supplier实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value = "/findDetailsById", method = {RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      Supplier result = this.supplierService.findDetailsById(id);
      return this.buildHttpResultW(result, new String[]{"products"});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "根据供应商编码查询供应商信息")
  @RequestMapping(value = "/findByCode", method = {RequestMethod.GET})
  public ResponseModel findByCode(@RequestParam("code") @ApiParam("供应商编码") String code) {
    try {
      Supplier result = this.supplierService.findByCode(code);
      return this.buildHttpResultW(result);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }


  /**
   * 多条件分页查询
   *
   * @param pageable
   * @param keyword
   * @return
   */
  @GetMapping("findByConditions")
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50")
  public ResponseModel findByConditions(@PageableDefault(50) Pageable pageable,
                                        @RequestParam(required = false) @ApiParam("关键字") String keyword) {
    try {
      Map<String, Object> conditions = Maps.newHashMap();
      conditions.put("keyword", keyword);
      Page<SupplierVo> page = supplierService.findByConditions(pageable, conditions);
      return this.buildHttpResultW(page);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }


  @ApiOperation(value = "供应商状态修改 状态：0(禁用) 1(启用)")
  @PutMapping("updateStatus")
  public ResponseModel updateStatus(@ApiParam("状态") @RequestParam("status") Integer status, @ApiParam("ID") @RequestParam("id") String id) {
    try {
      supplierService.updateByStatus(id,status);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
  /**
   * 查询所有供应商信息
   * @param tstatus  启用禁用状态
   * @return
   */
  @GetMapping("findByTstatus")
  @ApiOperation(value = "查询所有供应商信息")
  public ResponseModel findByTstatus(@RequestParam("tstatus") @ApiParam("状态") Integer tstatus) {
    try {
      List<Supplier> supplierList = supplierService.findByTstatus(tstatus);
      return this.buildHttpResultW(supplierList);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }



} 
