package com.bizunited.empower.business.purchase.controller;

import com.bizunited.empower.business.purchase.entity.SupplierProduct;
import com.bizunited.empower.business.purchase.service.SupplierProductService;
import com.bizunited.empower.business.purchase.vo.SupplierPurchaseProductVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.script.context.InvokeParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.lang.String;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * SupplierProduct业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/supplierProduct")
public class SupplierProductController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(SupplierProductController.class);
  
  @Autowired
  private SupplierProductService supplierProductService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建supplierProduct中的基本信息以外，还可以对supplierProduct中属于OneToMany关联的明细信息一同进行创建注意：基于（SupplierProduct）模型的创建操作传入的supplierProductJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建supplierProduct中的基本信息以外，还可以对supplierProduct中属于OneToMany关联的明细信息一同进行创建注意：基于（SupplierProduct）模型的创建操作传入的supplierProductJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="supplierProduct" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建supplierProduct中的基本信息以外，还可以对supplierProduct中属于OneToMany关联的明细信息一同进行创建注意：基于（SupplierProduct）模型的创建操作传入的supplierProductJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") SupplierProduct supplierProduct) {
    try {
      SupplierProduct current = this.supplierProductService.create(supplierProduct);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（SupplierProduct）的修改操作传入的supplierProductJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（SupplierProduct）的修改操作传入的supplierProductJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="supplierProduct" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（SupplierProduct）的修改操作传入的supplierProductJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") SupplierProduct supplierProduct) {
    try {
      SupplierProduct current = this.supplierProductService.update(supplierProduct);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value="/{id}")
  public ResponseModel findById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      SupplierProduct current = this.supplierProductService.findById(id);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @DeleteMapping(value="/{id}")
  public ResponseModel deleteById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      this.supplierProductService.deleteById(id);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照SupplierProduct实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照SupplierProduct实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      SupplierProduct result = this.supplierProductService.findDetailsById(id); 
      return this.buildHttpResultW(result, new String[]{}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }

  /**
   * 根据条件分页查询
   * @param pageable
   * @return
   */
  @GetMapping("findByConditions")
  @ApiOperation(value = "根据经销商编码和多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;" +
      "可传的参数：supplierCode:供应商编码 shelfStatus：1 上架 2 下架，productCode：商品编码/商品名称（模糊），brandCode：品牌编码（精准），categoryCode：分类编码（精准），" +
      "sellingPriceLeft/sellingPriceRight：销售价格（范围），tagCode：标签编码（精准），categoryFlatCode：分类快速编号（它和它的子集），brandFlatCode：品牌快速编号（它和它的子集）" +
      "productCodeList：商品编码以逗号间隔的拼接串")
  public ResponseModel findByConditions(@PageableDefault(50) Pageable pageable,
                                                       HttpServletRequest request) {
    try {
      InvokeParams conditions = this.getInvokeParams(request);
      Page<SupplierPurchaseProductVo> page = supplierProductService.findByConditions(pageable, conditions);
      return this.buildHttpResult(page);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 从请求对象
   * @param request
   * @return
   */
  private InvokeParams getInvokeParams(HttpServletRequest request) {
    Map<String, Object> params = new HashMap<>();
    Enumeration<String> names = request.getParameterNames();
    if (names != null) {
      while (names.hasMoreElements()) {
        String name = names.nextElement();
        String[] values = request.getParameterValues(name);
        if (values != null && values.length == 1) {
          params.put(name, values[0]);
        } else if (values != null && values.length > 1) {
          params.put(name, values);
        }
      }
    }
    InvokeParams conditions = new InvokeParams();
    conditions.putInvokeParams(params);
    return conditions;
  }


} 
