package com.bizunited.empower.business.purchase.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author lihuan
 */
@ApiModel(description = "采购单查询DTO")
public class PurchaseOrderConditionDto {

  @ApiModelProperty("创建时间(起始)")
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  @ApiModelProperty("创建时间(截止)")
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;

  /**
   * 采购单状态
   */
  @ApiModelProperty(name = "purchaseOrderStatus", value = "采购单状态", required = true)
  private Integer purchaseOrderStatus;

  /**
   * 付款状态
   */
  @ApiModelProperty(name = "payStatus", value = "付款状态", required = true)
  private Integer payStatus;

  /**
   * 关键字
   */
  @ApiModelProperty("关键字")
  private String keyword;

  /**
   * 租户编码
   */
  private String tenantCode;

  public Date getCreateTimeStart() {
    return createTimeStart;
  }

  public void setCreateTimeStart(Date createTimeStart) {
    this.createTimeStart = createTimeStart;
  }

  public Date getCreateTimeEnd() {
    return createTimeEnd;
  }

  public void setCreateTimeEnd(Date createTimeEnd) {
    this.createTimeEnd = createTimeEnd;
  }

  public Integer getPurchaseOrderStatus() {
    return purchaseOrderStatus;
  }

  public void setPurchaseOrderStatus(Integer purchaseOrderStatus) {
    this.purchaseOrderStatus = purchaseOrderStatus;
  }

  public Integer getPayStatus() {
    return payStatus;
  }

  public void setPayStatus(Integer payStatus) {
    this.payStatus = payStatus;
  }

  public String getKeyword() {
    return keyword;
  }

  public void setKeyword(String keyword) {
    this.keyword = keyword;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }
}
