package com.bizunited.empower.business.purchase.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author lihuan
 */
@ApiModel(description = "采购退单查询DTO")
public class PurchaseReturnOrderConditionDto {

  @ApiModelProperty("创建时间(起始)")
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  @ApiModelProperty("创建时间(截止)")
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;

  /**
   * 采购退单状态
   */
  @ApiModelProperty(name = "purchaseReturnOrderStatus", value = "采购退单状态", required = true)
  private Integer purchaseRefundOrderStatus;

  /**
   * 退款状态
   */
  @ApiModelProperty(name = "refund", value = "退款状态", required = true)
  private Integer refund;

  /**
   * 关键字
   */
  @ApiModelProperty("关键字")
  private String keyword;

  /**
   * 租户编码
   */
  private String tenantCode;

  public Date getCreateTimeStart() {
    return createTimeStart;
  }

  public void setCreateTimeStart(Date createTimeStart) {
    this.createTimeStart = createTimeStart;
  }

  public Date getCreateTimeEnd() {
    return createTimeEnd;
  }

  public void setCreateTimeEnd(Date createTimeEnd) {
    this.createTimeEnd = createTimeEnd;
  }

  public Integer getPurchaseRefundOrderStatus() {
    return purchaseRefundOrderStatus;
  }

  public void setPurchaseRefundOrderStatus(Integer purchaseRefundOrderStatus) {
    this.purchaseRefundOrderStatus = purchaseRefundOrderStatus;
  }

  public Integer getRefund() {
    return refund;
  }

  public void setRefund(Integer refund) {
    this.refund = refund;
  }

  public String getKeyword() {
    return keyword;
  }

  public void setKeyword(String keyword) {
    this.keyword = keyword;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }
}
