package com.bizunited.empower.business.purchase.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * @author lihuan
 */
@ApiModel(value = "PurchaseOrder", description = "采购订单信息")
@Entity
@Table(name = "`puchase_order`", indexes = @Index(columnList = "tenant_code , purchase_order_code", unique = true))
@org.hibernate.annotations.Table(appliesTo = "`puchase_order`", comment = "采购订单信息")
@BuildCustomRepository
public class PurchaseOrder extends TenantOpEntity {
  private static final long serialVersionUID = -1902545797318299763L;

  /**
   * 采购单编码
   */
  @Column(name = "purchase_order_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 采购单编码 '")
  @SaturnColumn(description = "采购单编码")
  @ApiModelProperty("采购单编码")
  private String purchaseOrderCode;

  /**
   * 收货日期
   */
  @ApiModelProperty("收货日期")
  @Column(name = "receipt_date", nullable = false, columnDefinition = "datetime COMMENT '收货日期'")
  @SaturnColumn(description = "收货日期")
  private Date receiptDate;


  /**
   * 供应商编码
   */
  @Column(name = "supplier_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 供应商编码 '")
  @SaturnColumn(description = "供应商编码")
  @ApiModelProperty("供应商编码")
  private String supplierCode;


  /**
   * 供应商名称
   */
  @Column(name = "supplier_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 供应商名称 '")
  @SaturnColumn(description = "供应商名称")
  @ApiModelProperty("供应商名称")
  private String supplierName;


  /**
   * 业务员编号
   */
  @Column(name = "salesman_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 业务员编号 '")
  @SaturnColumn(description = "业务员编号")
  @ApiModelProperty("业务员编号")
  private String salesmanCode;

  /**
   * 业务员名称
   */
  @Column(name = "salesman_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 业务员名称 '")
  @SaturnColumn(description = "业务员名称")
  @ApiModelProperty("业务员名称")
  private String salesmanName;


  /**
   * 采购单状态 0 待审核 1 待入库 2 部分入库 3 已完成 4 已取消
   */
  @Column(name = "purchase_order_status", nullable = false,columnDefinition = "INT(2) COMMENT '采购单状态 0 待审核 1 待入库 2 部分入库 3 已完成 4 已取消'")
  @SaturnColumn(description = "采购单状态 0 待审核 1 待入库 2 部分入库 3 已完成 4 已取消")
  @ApiModelProperty(name = "purchaseOrderStatus", value = "采购单状态 0 待审核 1 待入库 2 部分入库 3 已完成 4 已取消", required = true)
  private Integer purchaseOrderStatus;

  /**
   * 付款状态 0 待付款  1 部分入库 2 已付款 3 已取消
   */
  @Column(name = "pay_status", nullable = false,columnDefinition = "INT(2) COMMENT '付款状态 0 待付款  1 部分入库 2 已付款 3 已取消'")
  @SaturnColumn(description = "付款状态 0 待付款  1 部分入库 2 已付款 3 已取消")
  @ApiModelProperty(name = "payStatus", value = "付款状态 0 待付款  1 部分入库 2 已付款 3 已取消", required = true)
  private Integer payStatus;

  /**
   * 仓库编码
   */
  @Column(name = "warehouse_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 仓库编码 '")
  @SaturnColumn(description = "仓库编码")
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @Column(name = "warehouse_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 仓库名称 '")
  @SaturnColumn(description = "仓库名称")
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 商品总额
   */
  @Column(name = "total_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '商品总额'")
  @SaturnColumn(description = "商品总额")
  @ApiModelProperty("商品总额")
  private BigDecimal totalAmount;

  /**
   * 备注
   */
  @Column(name = "remark", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 备注信息 '")
  @SaturnColumn(description = "备注信息")
  @ApiModelProperty("备注信息")
  private String remark;

  @SaturnColumn(description = "采购单商品")
  @ApiModelProperty("采购单商品")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "purchaseOrder")
  private Set<PurchaseOrderProduct> productSet;

  /**
   * 采购单文件
   */
  @SaturnColumn(description = "采购单文件")
  @ApiModelProperty("采购单文件")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "purchaseOrder")
  private Set<PurchaseOrderFile> purchaseOrderFiles;


  public String getPurchaseOrderCode() {
    return purchaseOrderCode;
  }

  public void setPurchaseOrderCode(String purchaseOrderCode) {
    this.purchaseOrderCode = purchaseOrderCode;
  }

  public Date getReceiptDate() {
    return receiptDate;
  }

  public void setReceiptDate(Date receiptDate) {
    this.receiptDate = receiptDate;
  }

  public String getSupplierCode() {
    return supplierCode;
  }

  public void setSupplierCode(String supplierCode) {
    this.supplierCode = supplierCode;
  }

  public String getSupplierName() {
    return supplierName;
  }

  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }

  public String getSalesmanCode() {
    return salesmanCode;
  }

  public void setSalesmanCode(String salesmanCode) {
    this.salesmanCode = salesmanCode;
  }

  public String getSalesmanName() {
    return salesmanName;
  }

  public void setSalesmanName(String salesmanName) {
    this.salesmanName = salesmanName;
  }

  public Integer getPurchaseOrderStatus() {
    return purchaseOrderStatus;
  }

  public void setPurchaseOrderStatus(Integer purchaseOrderStatus) {
    this.purchaseOrderStatus = purchaseOrderStatus;
  }

  public Integer getPayStatus() {
    return payStatus;
  }

  public void setPayStatus(Integer payStatus) {
    this.payStatus = payStatus;
  }

  public String getWarehouseCode() {
    return warehouseCode;
  }

  public void setWarehouseCode(String warehouseCode) {
    this.warehouseCode = warehouseCode;
  }

  public String getWarehouseName() {
    return warehouseName;
  }

  public void setWarehouseName(String warehouseName) {
    this.warehouseName = warehouseName;
  }

  public BigDecimal getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(BigDecimal totalAmount) {
    this.totalAmount = totalAmount;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Set<PurchaseOrderProduct> getProductSet() {
    return productSet;
  }

  public void setProductSet(Set<PurchaseOrderProduct> productSet) {
    this.productSet = productSet;
  }

  public Set<PurchaseOrderFile> getPurchaseOrderFiles() {
    return purchaseOrderFiles;
  }

  public void setPurchaseOrderFiles(Set<PurchaseOrderFile> purchaseOrderFiles) {
    this.purchaseOrderFiles = purchaseOrderFiles;
  }
}
