package com.bizunited.empower.business.purchase.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * @author lihuan
 * 采购单订单文件
 */
@ApiModel(value = "PurchaseOrderFile", description = "采购订单文件")
@Entity
@Table(name = "purchase_order_file" , indexes = @Index(columnList = "relative_path,refile_name",unique = true))
@org.hibernate.annotations.Table(appliesTo = "purchase_order_file", comment = "采购订单文件")
public class PurchaseOrderFile extends TenantOpEntity {
  private static final long serialVersionUID = 2384135473493602545L;

  /**
   * 采购单编号
   */
  @ManyToOne(fetch = FetchType.LAZY, targetEntity = PurchaseOrder.class)
  @JoinColumn(name = "purchase_order_id",nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 采购单编号 '")
  @SaturnColumn(description = "采购单编号")
  private PurchaseOrder purchaseOrder;

  /**
   * 相对路径
   */
  @Column(name = "relative_path", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 相对路径 '")
  @SaturnColumn(description = "相对路径")
  @ApiModelProperty("相对路径")
  private String relativePath;
  /**
   * 原始文件名
   */
  @Column(name = "file_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '原始文件名 '")
  @SaturnColumn(description = "原始文件名")
  @ApiModelProperty("原始文件名")
  private String fileName;
  /**
   * 重命名后的文件名
   */
  @Column(name = "refile_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '重命名后的文件名 '")
  @SaturnColumn(description = "重命名后的文件名")
  @ApiModelProperty("重命名后的文件名")
  private String reFileName;

  public PurchaseOrder getPurchaseOrder() {
    return purchaseOrder;
  }

  public void setPurchaseOrder(PurchaseOrder purchaseOrder) {
    this.purchaseOrder = purchaseOrder;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getReFileName() {
    return reFileName;
  }

  public void setReFileName(String reFileName) {
    this.reFileName = reFileName;
  }
}
