package com.bizunited.empower.business.purchase.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;

/**
 * 采购订单商品信息
 * @author lihuan
 */
@ApiModel(value = "PurchaseOrderProduct", description = "采购订单商品信息")
@Entity
@Table(name = "`purchase_order_product`", indexes = @Index(columnList = "tenant_code , product_code"))
@org.hibernate.annotations.Table(appliesTo = "`purchase_order_product`", comment = "采购订单商品信息")
@BuildCustomRepository
public class PurchaseOrderProduct extends TenantOpEntity {
  private static final long serialVersionUID = 5767213515174075022L;

  @JoinColumn(name = "purchase_order_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 采购单ID '")
  @SaturnColumn(description = "采购单ID")
  @ApiModelProperty("采购单ID")
  @ManyToOne(fetch = FetchType.LAZY)
  private PurchaseOrder purchaseOrder;

  /**
   * 商品编码
   */
  @Column(name = "product_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
  @SaturnColumn(description = "商品编码")
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @Column(name = "product_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 商品名称 '")
  @SaturnColumn(description = "商品名称")
  @ApiModelProperty("商品名称")
  private String productName;


  /**
   * 主图路径
   */
  @Column(name = "main_image_path", length = 255, nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 主图路径 '")
  @SaturnColumn(description = "主图路径")
  @ApiModelProperty("主图路径")
  private String mainImagePath;

  /**
   * 品牌编码
   */
  @Column(name = "brand_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 品牌编码 '")
  @SaturnColumn(description = "品牌编码")
  @ApiModelProperty("品牌编码")
  private String brandCode;

  /**
   * 品牌名称
   */
  @Column(name = "brand_name", nullable = true, length = 1024, columnDefinition = "VARCHAR(1024) COMMENT ' 品牌名称 '")
  @SaturnColumn(description = "品牌名称")
  @ApiModelProperty("品牌名称")
  private String brandName;


  /** 商品（规格）编码 */
  @Column(name = "product_specification_code", nullable = false , length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 商品（规格）编码 '")
  @SaturnColumn(description = "商品（规格）编码")
  @ApiModelProperty("商品（规格）编码")
  private String productSpecificationCode;

  /** 商品（规格）名称 */
  @Column(name = "product_specification_name", nullable = false , length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 商品（规格）名称 '")
  @SaturnColumn(description = "商品（规格）名称")
  @ApiModelProperty("商品（规格）名称")
  private String productSpecificationName;


  /** 单位 */
  @Column(name = "unit_code", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 单位 '")
  @SaturnColumn(description = "单位")
  @ApiModelProperty("单位")
  private String unitCode;
  /** 单位 */
  @Column(name = "unit_name", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 单位 '")
  @SaturnColumn(description = "单位")
  @ApiModelProperty("单位")
  private String unitName;

  /**
   * 分类编码
   */
  @Column(name = "category_code", nullable = true, length = 255, columnDefinition = "VARCHAR(64) COMMENT ' 分类编码 '")
  @SaturnColumn(description = "分类编码")
  @ApiModelProperty("分类编码")
  private String categoryCode;

  /**
   * 分类名称
   */
  @Column(name = "category_name", nullable = true, length = 255, columnDefinition = "VARCHAR(64) COMMENT ' 分类名称 '")
  @SaturnColumn(description = "分类名称")
  @ApiModelProperty("分类名称")
  private String categoryName;

  /**
   * 分类快速编码
   */
  @Column(name = "category_flat_code", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 快速编号 '")
  @SaturnColumn(description = "快速编号")
  @ApiModelProperty("快速编号")
  private String categoryFlatCode;

  /** 条形码 */
  @Column(name = "bar_code",length = 64,columnDefinition = "VARCHAR(64) COMMENT ' 条形码 '")
  @SaturnColumn(description = "条形码")
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 采购数量
   */
  @Column(name = "quantity", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '采购数量'")
  @SaturnColumn(description = "采购数量")
  @ApiModelProperty(" 采购数量")
  private BigDecimal quantity;

  /**
   * 进货单价
   */
  @Column(name = "price", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '进货单价'")
  @SaturnColumn(description = "进货单价")
  @ApiModelProperty("进货单价")
  private BigDecimal price;

  /**
   * 小计
   */
  @Column(name = "amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '小计'")
  @SaturnColumn(description = "小计")
  @ApiModelProperty("小计")
  private BigDecimal amount;



  /**
   * 备注
   */
  @Column(name = "remark", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 备注信息 '")
  @SaturnColumn(description = "备注信息")
  @ApiModelProperty("备注信息")
  private String remark;

  /**
   * 可用库存量
   */
  @Transient
  @ApiModelProperty("可用库存量（后四位是小数的转换）")
  private BigDecimal usableInventory;

  public PurchaseOrder getPurchaseOrder() {
    return purchaseOrder;
  }

  public void setPurchaseOrder(PurchaseOrder purchaseOrder) {
    this.purchaseOrder = purchaseOrder;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public String getMainImagePath() {
    return mainImagePath;
  }

  public void setMainImagePath(String mainImagePath) {
    this.mainImagePath = mainImagePath;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }

  public String getBrandName() {
    return brandName;
  }

  public void setBrandName(String brandName) {
    this.brandName = brandName;
  }

  public String getProductSpecificationCode() {
    return productSpecificationCode;
  }

  public void setProductSpecificationCode(String productSpecificationCode) {
    this.productSpecificationCode = productSpecificationCode;
  }

  public String getProductSpecificationName() {
    return productSpecificationName;
  }

  public void setProductSpecificationName(String productSpecificationName) {
    this.productSpecificationName = productSpecificationName;
  }

  public String getUnitCode() {
    return unitCode;
  }

  public void setUnitCode(String unitCode) {
    this.unitCode = unitCode;
  }

  public String getCategoryCode() {
    return categoryCode;
  }

  public void setCategoryCode(String categoryCode) {
    this.categoryCode = categoryCode;
  }

  public String getCategoryName() {
    return categoryName;
  }

  public void setCategoryName(String categoryName) {
    this.categoryName = categoryName;
  }

  public String getCategoryFlatCode() {
    return categoryFlatCode;
  }

  public void setCategoryFlatCode(String categoryFlatCode) {
    this.categoryFlatCode = categoryFlatCode;
  }

  public String getBarCode() {
    return barCode;
  }

  public void setBarCode(String barCode) {
    this.barCode = barCode;
  }

  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }

  public BigDecimal getPrice() {
    return price;
  }

  public void setPrice(BigDecimal price) {
    this.price = price;
  }

  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public BigDecimal getUsableInventory() {
    return usableInventory;
  }

  public void setUsableInventory(BigDecimal usableInventory) {
    this.usableInventory = usableInventory;
  }

  public String getUnitName() {
    return unitName;
  }

  public void setUnitName(String unitName) {
    this.unitName = unitName;
  }
}
