package com.bizunited.empower.business.purchase.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Set;

/**
 * @author lihuan
 */
@ApiModel(value = "PurchaseReturnOrder", description = "采购退货单信息")
@Entity
@Table(name = "`purchase_return_order`", indexes = @Index(columnList = "tenant_code , purchase_return_order_code", unique = true))
@org.hibernate.annotations.Table(appliesTo = "`purchase_return_order`", comment = "采购退货单信息")
@BuildCustomRepository
public class PurchaseReturnOrder extends TenantOpEntity {
  private static final long serialVersionUID = -1902545797318299763L;

  /**
   * 退货单编码
   */
  @Column(name = "purchase_return_order_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 退货单编码 '")
  @SaturnColumn(description = "退货单编码")
  @ApiModelProperty("退货单编码")
  private String purchaseReturnOrderCode;


  /**
   * 供应商编码
   */
  @Column(name = "supplier_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 供应商编码 '")
  @SaturnColumn(description = "供应商编码")
  @ApiModelProperty("供应商编码")
  private String supplierCode;


  /**
   * 供应商名称
   */
  @Column(name = "supplier_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 供应商名称 '")
  @SaturnColumn(description = "供应商名称")
  @ApiModelProperty("供应商名称")
  private String supplierName;



  /**
   * 退货单状态
   */
  @Column(name = "purchase_return_order_status", nullable = false,columnDefinition = "INT(2) COMMENT '退货单状态'")
  @SaturnColumn(description = "退货单状态")
  @ApiModelProperty(name = "purchaseReturnOrderStatus", value = "退货单状态", required = true)
  private Integer purchaseReturnOrderStatus;


  /**
   * 退款状态
   */
  @Column(name = "refund_status", nullable = false,columnDefinition = "INT(2) COMMENT '退款状态'")
  @SaturnColumn(description = "退款状态")
  @ApiModelProperty(name = "refundStatus", value = "退款状态", required = true)
  private Integer refundStatus;

  /**
   * 退货总额
   */
  @Column(name = "total_amount", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '退货总额'")
  @SaturnColumn(description = "退货总额")
  @ApiModelProperty("退货总额")
  private BigDecimal totalAmount;

  /**
   * 备注
   */
  @Column(name = "remark", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 备注信息 '")
  @SaturnColumn(description = "备注信息")
  @ApiModelProperty("备注信息")
  private String remark;

  @SaturnColumn(description = "采购退货单商品")
  @ApiModelProperty("采购单商品")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "purchaseReturnOrder")
  private Set<PurchaseReturnOrderProduct> productSet;

  /**
   * 采购单文件
   */
  @SaturnColumn(description = "采购退货单文件")
  @ApiModelProperty("采购退货单文件")
  @OneToMany(fetch = FetchType.LAZY,mappedBy = "purchaseReturnOrder")
  private Set<PurchaseReturnOrderFile> purchaseOrderFiles;


  public String getPurchaseReturnOrderCode() {
    return purchaseReturnOrderCode;
  }

  public void setPurchaseReturnOrderCode(String purchaseReturnOrderCode) {
    this.purchaseReturnOrderCode = purchaseReturnOrderCode;
  }
  public String getSupplierCode() {
    return supplierCode;
  }

  public void setSupplierCode(String supplierCode) {
    this.supplierCode = supplierCode;
  }

  public String getSupplierName() {
    return supplierName;
  }

  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }

  public Integer getPurchaseReturnOrderStatus() {
    return purchaseReturnOrderStatus;
  }

  public void setPurchaseReturnOrderStatus(Integer purchaseReturnOrderStatus) {
    this.purchaseReturnOrderStatus = purchaseReturnOrderStatus;
  }

  public BigDecimal getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(BigDecimal totalAmount) {
    this.totalAmount = totalAmount;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Set<PurchaseReturnOrderProduct> getProductSet() {
    return productSet;
  }

  public void setProductSet(Set<PurchaseReturnOrderProduct> productSet) {
    this.productSet = productSet;
  }

  public Set<PurchaseReturnOrderFile> getPurchaseOrderFiles() {
    return purchaseOrderFiles;
  }

  public void setPurchaseOrderFiles(Set<PurchaseReturnOrderFile> purchaseOrderFiles) {
    this.purchaseOrderFiles = purchaseOrderFiles;
  }


  public Integer getRefundStatus() {
    return refundStatus;
  }

  public void setRefundStatus(Integer refundStatus) {
    this.refundStatus = refundStatus;
  }
}
