package com.bizunited.empower.business.purchase.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * @author lihuan
 * 采购退货单文件
 */
@ApiModel(value = "PurchaseReturnOrderFile", description = "采购退货单文件")
@Entity
@Table(name = "purchase_return_order_file" , indexes = @Index(columnList = "relative_path,refile_name",unique = true))
@org.hibernate.annotations.Table(appliesTo = "purchase_return_order_file", comment = "采购退货单文件")
public class PurchaseReturnOrderFile extends TenantOpEntity {
  private static final long serialVersionUID = 2384135473493602545L;

  /**
   * 采购退货单编号
   */
  @ManyToOne(fetch = FetchType.LAZY, targetEntity = PurchaseReturnOrder.class)
  @JoinColumn(name = "purchase_return_order_id",nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 采购退货单编号 '")
  @SaturnColumn(description = "采购退货单编号")
  private PurchaseReturnOrder purchaseReturnOrder;

  /**
   * 相对路径
   */
  @Column(name = "relative_path", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 相对路径 '")
  @SaturnColumn(description = "相对路径")
  @ApiModelProperty("相对路径")
  private String relativePath;
  /**
   * 原始文件名
   */
  @Column(name = "file_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '原始文件名 '")
  @SaturnColumn(description = "原始文件名")
  @ApiModelProperty("原始文件名")
  private String fileName;
  /**
   * 重命名后的文件名
   */
  @Column(name = "refile_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '重命名后的文件名 '")
  @SaturnColumn(description = "重命名后的文件名")
  @ApiModelProperty("重命名后的文件名")
  private String reFileName;

  public PurchaseReturnOrder getPurchaseReturnOrder() {
    return purchaseReturnOrder;
  }

  public void setPurchaseReturnOrder(PurchaseReturnOrder purchaseReturnOrder) {
    this.purchaseReturnOrder = purchaseReturnOrder;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getReFileName() {
    return reFileName;
  }

  public void setReFileName(String reFileName) {
    this.reFileName = reFileName;
  }
}
