package com.bizunited.empower.business.purchase.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

/**
 * @author lihuan
 */
@ApiModel(value = "Supplier", description = "供应商信息")
@Entity
@Table(name = "`supplier`" , indexes = @Index(columnList = "tenant_code , supplier_code", unique = true))
@org.hibernate.annotations.Table(appliesTo = "`supplier`", comment = "供应商信息")
@BuildCustomRepository
public class Supplier extends TenantOpEntity {


    /**
     *
     */
    private static final long serialVersionUID = -184310780544785082L;
    /**
     * 供应商编码
     */
    @Column(name = "supplier_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 供应商编码 '")
    @SaturnColumn(description = "供应商编码")
    @ApiModelProperty("供应商编码")
    private String supplierCode;


    /**
     * 供应商名称
     */
    @Column(name = "supplier_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 供应商名称 '")
    @SaturnColumn(description = "供应商名称")
    @ApiModelProperty("供应商名称")
    private String supplierName;

    /**
     * 联系人
     */
    @Column(name = "contanct", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 联系人 '")
    @SaturnColumn(description = "联系人")
    @ApiModelProperty("联系人")
    private String contanct;

    /**
     * 手机号
     */
    @Column(name = "mobile", nullable = false, length = 128, columnDefinition = "VARCHAR(11) COMMENT ' 手机号 '")
    @SaturnColumn(description = "手机号")
    @ApiModelProperty("手机号")
    private String mobile;

    /**
     * 供应商地址
     */
    @Column(name = "supplier_address", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 供应商地址 '")
    @SaturnColumn(description = "供应商地址")
    @ApiModelProperty("供应商地址")
    private String supplierAddress;

    /**
     * 开户名称
     */
    @Column(name = "account_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 开户名称 '")
    @SaturnColumn(description = "开户名称")
    @ApiModelProperty("开户名称")
    private String accountName;

    /**
     * 开户银行
     */
    @Column(name = "bank_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 开户银行 '")
    @SaturnColumn(description = "开户银行")
    @ApiModelProperty("开户银行")
    private String bankName;

    /**
     * 银行账号
     */
    @Column(name = "bank_code", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 银行账号 '")
    @SaturnColumn(description = "银行账号")
    @ApiModelProperty("银行账号")
    private String bankCode;


    /**
     * 开票抬头
     */
    @Column(name = "invoice_title", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 开票抬头 '")
    @SaturnColumn(description = "开票抬头")
    @ApiModelProperty("开票抬头")
    private String invoiceTitle;

    /**
     * 纳税人识别号
     */
    @Column(name = "taxpayer_number", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 纳税人识别号 '")
    @SaturnColumn(description = "纳税人识别号")
    @ApiModelProperty("纳税人识别号")
    private String taxpayerNumber;


    /**
     * 备注信息
     */
    @Column(name = "remark", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 备注信息 '")
    @SaturnColumn(description = "备注信息")
    @ApiModelProperty("备注信息")
    private String remark;

    /**
     * 状态：0(禁用) 1(启用)
     */
    @Column(name = "tstatus", nullable = false,columnDefinition = "INT(2) COMMENT '状态：0(禁用) 1(启用)'")
    @SaturnColumn(description = "状态")
    @ApiModelProperty(name = "tstatus", value = "状态：0(禁用) 1(启用)", required = true)
    private Integer tstatus = 1;

    /**
     * 供应商品
     */
    @SaturnColumn(description = "供应商品")
    @ApiModelProperty("供应商品")
    @OneToMany(fetch = FetchType.LAZY,mappedBy = "supplier")
    private Set<SupplierProduct> products;


    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getContanct() {
        return contanct;
    }

    public void setContanct(String contanct) {
        this.contanct = contanct;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public String getTaxpayerNumber() {
        return taxpayerNumber;
    }

    public void setTaxpayerNumber(String taxpayerNumber) {
        this.taxpayerNumber = taxpayerNumber;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getTstatus() {
        return tstatus;
    }

    public void setTstatus(Integer tstatus) {
        this.tstatus = tstatus;
    }

    public Set<SupplierProduct> getProducts() {
        return products;
    }

    public void setProducts(Set<SupplierProduct> products) {
        this.products = products;
    }
}
