package com.bizunited.empower.business.purchase.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author lihuan
 */
@ApiModel(value = "SupplierProduct", description = "供应商商品信息")
@Entity
@Table(name = "`supplier_product`" , indexes = @Index(columnList = "tenant_code , product_code"))
@org.hibernate.annotations.Table(appliesTo = "`supplier_product`", comment = "供应商商品信息")
@BuildCustomRepository
public class SupplierProduct extends TenantOpEntity {
    /**
     *
     */
    private static final long serialVersionUID = 2098486260649788946L;

    @JoinColumn(name = "supplier_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 供应商ID '")
    @SaturnColumn(description = "供应商ID")
    @ApiModelProperty("供应商ID")
    @ManyToOne(fetch = FetchType.LAZY)
    private Supplier supplier;


    /**
     * 商品编码
     */
    @Column(name = "product_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
    @SaturnColumn(description = "商品编码")
    @ApiModelProperty("商品编码")
    private String productCode;

    /**
     * 商品名称
     */
    @Column(name = "product_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 商品名称 '")
    @SaturnColumn(description = "商品名称")
    @ApiModelProperty("商品名称")
    private String productName;

    /**
     * 上架状态
     */
    @Column(name = "shelf_status", nullable = false, columnDefinition = "VARCHAR(32) COMMENT ' 上架状态 '")
    @SaturnColumn(description = "上架状态")
    @ApiModelProperty("上架状态：1，立即上架；2，暂不上架")
    private Integer shelfStatus;

    /**
     * 主图路径
     */
    @Column(name = "main_image_path", length = 255, nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 主图路径 '")
    @SaturnColumn(description = "主图路径")
    @ApiModelProperty("主图路径")
    private String mainImagePath;

    /**
     * 品牌编码
     */
    @Column(name = "brand_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 品牌编码 '")
    @SaturnColumn(description = "品牌编码")
    @ApiModelProperty("品牌编码")
    private String brandCode;

    /**
     * 品牌名称
     */
    @Column(name = "brand_name", nullable = true, length = 1024, columnDefinition = "VARCHAR(1024) COMMENT ' 品牌名称 '")
    @SaturnColumn(description = "品牌名称")
    @ApiModelProperty("品牌名称")
    private String brandName;


    /** 商品（规格）编码 */
    @Column(name = "product_specification_code", nullable = false , length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 商品（规格）编码 '")
    @SaturnColumn(description = "商品（规格）编码")
    @ApiModelProperty("商品（规格）编码")
    private String productSpecificationCode;

    /** 商品（规格）名称 */
    @Column(name = "product_specification_name", nullable = false , length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 商品（规格）名称 '")
    @SaturnColumn(description = "商品（规格）名称")
    @ApiModelProperty("商品（规格）名称")
    private String productSpecificationName;


    /** 单位 */
    @Column(name = "unit_code", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 单位 '")
    @SaturnColumn(description = "单位")
    @ApiModelProperty("单位")
    private String unitCode;
    /** 单位 */
    @Column(name = "unit_name", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 单位 '")
    @SaturnColumn(description = "单位")
    @ApiModelProperty("单位")
    private String unitName;


    /** 订货参考价 */
    @Column(name = "reference_price", nullable = false, precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT '订货参考价'")
    @SaturnColumn(description = "订货参考价")
    @ApiModelProperty("订货参考价")
    private BigDecimal referencePrice;

    /**
     * 分类编码
     */
    @Column(name = "category_code", nullable = true, length = 255, columnDefinition = "VARCHAR(64) COMMENT ' 分类编码 '")
    @SaturnColumn(description = "分类编码")
    @ApiModelProperty("分类编码")
    private String categoryCode;

    /**
     * 分类名称
     */
    @Column(name = "category_name", nullable = true, length = 255, columnDefinition = "VARCHAR(64) COMMENT ' 分类名称 '")
    @SaturnColumn(description = "分类名称")
    @ApiModelProperty("分类名称")
    private String categoryName;

    /**
     * 分类快速编码
     */
    @Column(name = "category_flat_code", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 快速编号 '")
    @SaturnColumn(description = "快速编号")
    @ApiModelProperty("快速编号")
    private String categoryFlatCode;



    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Integer getShelfStatus() {
        return shelfStatus;
    }

    public void setShelfStatus(Integer shelfStatus) {
        this.shelfStatus = shelfStatus;
    }

    public String getMainImagePath() {
        return mainImagePath;
    }

    public void setMainImagePath(String mainImagePath) {
        this.mainImagePath = mainImagePath;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getProductSpecificationCode() {
        return productSpecificationCode;
    }

    public void setProductSpecificationCode(String productSpecificationCode) {
        this.productSpecificationCode = productSpecificationCode;
    }

    public String getProductSpecificationName() {
        return productSpecificationName;
    }

    public void setProductSpecificationName(String productSpecificationName) {
        this.productSpecificationName = productSpecificationName;
    }

    public String getUnitCode() {
        return unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public BigDecimal getReferencePrice() {
        return referencePrice;
    }

    public void setReferencePrice(BigDecimal referencePrice) {
        this.referencePrice = referencePrice;
    }

    public Supplier getSupplier() {
        return supplier;
    }

    public void setSupplier(Supplier supplier) {
        this.supplier = supplier;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryFlatCode() {
        return categoryFlatCode;
    }

    public void setCategoryFlatCode(String categoryFlatCode) {
        this.categoryFlatCode = categoryFlatCode;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
}
