package com.bizunited.empower.business.purchase.repository;
import com.bizunited.empower.business.purchase.entity.PurchaseOrderFile;
import java.lang.String;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * PurchaseOrderFile业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_PurchaseOrderFileRepository")
public interface PurchaseOrderFileRepository
    extends
      JpaRepository<PurchaseOrderFile, String>
      ,JpaSpecificationExecutor<PurchaseOrderFile>
  {
  /**
   * 按照采购单编号进行详情查询（包括关联信息）
   * @param purchaseOrder 采购单编号
   * */
  @Query("select distinct purchaseOrderFile from PurchaseOrderFile purchaseOrderFile "
      + " left join fetch purchaseOrderFile.purchaseOrder purchaseOrderFile_purchaseOrder "
       + " where purchaseOrderFile_purchaseOrder.id = :id")
  Set<PurchaseOrderFile> findDetailsByPurchaseOrder(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct purchaseOrderFile from PurchaseOrderFile purchaseOrderFile "
      + " left join fetch purchaseOrderFile.purchaseOrder purchaseOrderFile_purchaseOrder "
      + " where purchaseOrderFile.id=:id ")
  PurchaseOrderFile findDetailsById(@Param("id") String id);

    /**
     * 删除采购单文件信息
     * @param orderId
     */
    @Modifying
    @Query("delete from PurchaseOrderFile s where s.purchaseOrder.id =:orderId")
  void deleteByOrderId(@Param("orderId") String orderId);

    /**
     * 删除采购单文件信息
     * @param orderId
     * @param ids
     */
    @Modifying
    @Query("delete from PurchaseOrderFile s where s.purchaseOrder.id =:orderId and s.id not in(:ids)")
    void deleteByOrderIdAndNotInIds(@Param("orderId") String orderId, @Param("ids") List<String> ids);

    /**
     * 通过订单Id 查询文件信息
     * @param orderId
     * @return
     */
    @Query("from PurchaseOrderFile s where s.purchaseOrder.id =:orderId")
    Set<PurchaseOrderFile> findByPurchaseOrderId(@Param("orderId") String orderId);

  }