package com.bizunited.empower.business.purchase.repository;
import com.bizunited.empower.business.purchase.entity.PurchaseOrderProduct;
import com.bizunited.empower.business.purchase.repository.internal.PurchaseOrderProductRepositoryCustom;
import java.lang.String;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * PurchaseOrderProduct业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_PurchaseOrderProductRepository")
public interface PurchaseOrderProductRepository
    extends
      JpaRepository<PurchaseOrderProduct, String>
      ,JpaSpecificationExecutor<PurchaseOrderProduct>
      , PurchaseOrderProductRepositoryCustom 
  {
  /**
   * 按照采购单ID进行详情查询（包括关联信息）
   * @param purchaseOrder 采购单ID
   * */
  @Query("select distinct purchaseOrderProduct from PurchaseOrderProduct purchaseOrderProduct "
      + " left join fetch purchaseOrderProduct.purchaseOrder purchaseOrderProduct_purchaseOrder "
       + " where purchaseOrderProduct_purchaseOrder.id = :id")
  Set<PurchaseOrderProduct> findDetailsByPurchaseOrder(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct purchaseOrderProduct from PurchaseOrderProduct purchaseOrderProduct "
      + " left join fetch purchaseOrderProduct.purchaseOrder purchaseOrderProduct_purchaseOrder "
      + " where purchaseOrderProduct.id=:id ")
  PurchaseOrderProduct findDetailsById(@Param("id") String id);

    /**
     * 删除多余的商品信息
     * @param orderId
     * @param ids
     */
    @Modifying
    @Query("delete from PurchaseOrderProduct s where s.purchaseOrder.id =:orderId and s.id not in(:ids)")
  void deleteByOrderIdAndNotInIds(@Param("orderId") String orderId, @Param("ids") List<String> ids);

    /**
     * 通过订单ID查询商品信息
     * @param orderId
     * @return
     */
    @Query("from PurchaseOrderProduct s where s.purchaseOrder.id =:orderId")
  List<PurchaseOrderProduct> findByOrderId(@Param("orderId") String orderId);

}