package com.bizunited.empower.business.purchase.repository;
import com.bizunited.empower.business.purchase.entity.PurchaseOrder;
import com.bizunited.empower.business.purchase.repository.internal.PurchaseOrderRepositoryCustom;
import java.lang.String;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * PurchaseOrder业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_PurchaseOrderRepository")
public interface PurchaseOrderRepository
    extends
      JpaRepository<PurchaseOrder, String>
      ,JpaSpecificationExecutor<PurchaseOrder>
      , PurchaseOrderRepositoryCustom 
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct purchaseOrder from PurchaseOrder purchaseOrder " +
      "left join fetch purchaseOrder.productSet purchaseOrder_productSet " +
      "left join fetch purchaseOrder.purchaseOrderFiles purchaseOrder_purchaseOrderFiles"
      + " where purchaseOrder.id=:id ")
  PurchaseOrder findDetailsById(@Param("id") String id);


    /**
     * 根据订单编码和租户编码获取数据
     * @param purchaseOrderCode
     * @param tenantCode
     * @return
     */
  @Query("from PurchaseOrder where purchaseOrderCode=:purchaseOrderCode and tenantCode=:tenantCode")
  PurchaseOrder findByPurchaseOrderCodeAndTenantCode(@Param("purchaseOrderCode") String purchaseOrderCode, @Param("tenantCode") String tenantCode);

    /**
     * 通过采购单编号查询采购单信息
     * @param purchaseOrderCode
     * @return
     */
  PurchaseOrder findByPurchaseOrderCode(@Param("purchaseOrderCode") String purchaseOrderCode);
}