package com.bizunited.empower.business.purchase.repository;
import com.bizunited.empower.business.purchase.entity.PurchaseReturnOrderFile;
import java.lang.String;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * PurchaseReturnOrderFile业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_PurchaseReturnOrderFileRepository")
public interface PurchaseReturnOrderFileRepository
    extends
      JpaRepository<PurchaseReturnOrderFile, String>
      ,JpaSpecificationExecutor<PurchaseReturnOrderFile>
  {
  /**
   * 按照采购退货单编号进行详情查询（包括关联信息）
   * @param purchaseReturnOrder 采购退货单编号
   * */
  @Query("select distinct purchaseReturnOrderFile from PurchaseReturnOrderFile purchaseReturnOrderFile "
      + " left join fetch purchaseReturnOrderFile.purchaseReturnOrder purchaseReturnOrderFile_purchaseReturnOrder "
       + " where purchaseReturnOrderFile_purchaseReturnOrder.id = :id")
  Set<PurchaseReturnOrderFile> findDetailsByPurchaseReturnOrder(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct purchaseReturnOrderFile from PurchaseReturnOrderFile purchaseReturnOrderFile "
      + " left join fetch purchaseReturnOrderFile.purchaseReturnOrder purchaseReturnOrderFile_purchaseReturnOrder "
      + " where purchaseReturnOrderFile.id=:id ")
  PurchaseReturnOrderFile findDetailsById(@Param("id") String id);


    /**
     * 删除多余的商品信息
     * @param orderId
     * @param tenantCode
     */
    @Modifying
    @Query("delete from PurchaseReturnOrderFile s where s.purchaseReturnOrder.id =:orderId")
  void deleteByOrderId(@Param("orderId") String orderId);
    /**
     * 删除多余的商品信息
     * @param orderId
     * @param tenantCode
     * @param ids
     */
    @Modifying
    @Query("delete from PurchaseReturnOrderFile s where s.purchaseReturnOrder.id =:orderId and s.id not in(:ids)")
    void deleteByOrderIdAndNotInIds(@Param("orderId") String orderId, @Param("ids") List<String> ids);

    /**
     * 通过退单ID 获取采购退单文件列表
     * @param orderId
     * @return
     */
    @Query("from PurchaseReturnOrderFile s where s.purchaseReturnOrder.id =:orderId")
    Set<PurchaseReturnOrderFile> findByPurchaseReturnOrderId(@Param("orderId") String orderId);
}