package com.bizunited.empower.business.purchase.repository;

import com.bizunited.empower.business.purchase.entity.PurchaseReturnOrderProduct;
import com.bizunited.empower.business.purchase.repository.internal.PurchaseReturnOrderProductRepositoryCustom;

import java.lang.String;
import java.util.List;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * PurchaseReturnOrderProduct业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_PurchaseReturnOrderProductRepository")
public interface PurchaseReturnOrderProductRepository
    extends
    JpaRepository<PurchaseReturnOrderProduct, String>
    , JpaSpecificationExecutor<PurchaseReturnOrderProduct>
    , PurchaseReturnOrderProductRepositoryCustom {
  /**
   * 按照采购退货单ID进行详情查询（包括关联信息）
   *
   * @param purchaseReturnOrder 采购退货单ID
   */
  @Query("select distinct purchaseReturnOrderProduct from PurchaseReturnOrderProduct purchaseReturnOrderProduct "
      + " left join fetch purchaseReturnOrderProduct.purchaseReturnOrder purchaseReturnOrderProduct_purchaseReturnOrder "
      + " where purchaseReturnOrderProduct_purchaseReturnOrder.id = :id")
  Set<PurchaseReturnOrderProduct> findDetailsByPurchaseReturnOrder(@Param("id") String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct purchaseReturnOrderProduct from PurchaseReturnOrderProduct purchaseReturnOrderProduct "
      + " left join fetch purchaseReturnOrderProduct.purchaseReturnOrder purchaseReturnOrderProduct_purchaseReturnOrder "
      + " where purchaseReturnOrderProduct.id=:id ")
  PurchaseReturnOrderProduct findDetailsById(@Param("id") String id);


  /**
   * 删除多余商品信息
   *
   * @param orderId
   * @param tenantCode
   * @param ids
   */
  @Modifying
  @Query("delete from PurchaseReturnOrderProduct s where  s.purchaseReturnOrder.id=:orderId and s.id not in(:ids)")
  void deleteByOrderIdAndNotInIds(@Param("orderId") String orderId, @Param("ids") List<String> ids);

  /**
   * 通过退单ID 查询商品列表
   * @param orderId
   * @return
   */
  @Query("from PurchaseReturnOrderProduct s where s.purchaseReturnOrder.id =:orderId")
  List<PurchaseReturnOrderProduct> findByOrderId(@Param("orderId") String orderId);
}