package com.bizunited.empower.business.purchase.repository;
import com.bizunited.empower.business.purchase.entity.PurchaseReturnOrder;
import com.bizunited.empower.business.purchase.repository.internal.PurchaseReturnOrderRepositoryCustom;
import java.lang.String;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * PurchaseReturnOrder业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_PurchaseReturnOrderRepository")
public interface PurchaseReturnOrderRepository
    extends
      JpaRepository<PurchaseReturnOrder, String>
      ,JpaSpecificationExecutor<PurchaseReturnOrder>
      , PurchaseReturnOrderRepositoryCustom 
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct purchaseReturnOrder from PurchaseReturnOrder purchaseReturnOrder " +
      "left join fetch purchaseReturnOrder.productSet purchaseReturnOrder_productSet " +
      "left join fetch purchaseReturnOrder.purchaseOrderFiles purchaseReturnOrder_purchaseOrderFiles "
      + " where purchaseReturnOrder.id=:id ")
  PurchaseReturnOrder findDetailsById(@Param("id") String id);


    /**
     * 根据退单编码和租户编码查询退单信息
     * @param purchaseReturnOrderCode
     * @param tenanCode
     * @return
     */
  @Query("from PurchaseReturnOrder where purchaseReturnOrderCode=:purchaseReturnOrderCode and tenantCode =:tenanCode")
  PurchaseReturnOrder findByPurchaseReturnOrderCodeAndTenantCode(@Param("purchaseReturnOrderCode") String purchaseReturnOrderCode, @Param("tenanCode") String tenanCode);

}