package com.bizunited.empower.business.purchase.repository;

import com.bizunited.empower.business.purchase.entity.SupplierProduct;
import com.bizunited.empower.business.purchase.repository.internal.SupplierProductRepositoryCustom;

import java.lang.String;
import java.util.List;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * SupplierProduct业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_SupplierProductRepository")
public interface SupplierProductRepository
    extends
    JpaRepository<SupplierProduct, String>
    , JpaSpecificationExecutor<SupplierProduct>
    , SupplierProductRepositoryCustom {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct supplierProduct from SupplierProduct supplierProduct "
      + " where supplierProduct.id=:id ")
  SupplierProduct findDetailsById(@Param("id") String id);


  /**
   * 删除多余商品信息
   *
   * @param supplierId
   * @param tenantCode
   * @param ids
   */
  @Modifying
  @Query("delete from SupplierProduct e where e.supplier.id=:supplierId  and e.id not in(:ids)")
  void deleteBySupplierIdAndNotInIds(@Param("supplierId") String supplierId, @Param("ids") List<String> ids);

  /**
   * 删除多余商品信息
   *
   * @param supplierId
   * @param tenantCode
   */
  @Modifying
  @Query("delete from SupplierProduct e where e.supplier.id=:supplierId ")
  void deleteBySupplierId(@Param("supplierId") String supplierId);


  @Query("from SupplierProduct s where s.supplier.supplierCode=:supplierCode and s.tenantCode =:tenantCode")
  Set<SupplierProduct> findBySupplierCodeAndTenantCode(@Param("supplierCode") String supplierCode, @Param("tenantCode") String tenantCode);


  @Modifying
  @Query("update SupplierProduct set shelfStatus=:shelfStatus where productCode=:productCode and tenantCode=:tenantCode")
  void updateShelfStatusByProductCodeAndTenantCode(@Param("productCode") String productCode, @Param("shelfStatus") Integer shelfStatus, @Param("tenantCode") String tenantCode);

}