package com.bizunited.empower.business.purchase.repository;

import com.bizunited.empower.business.purchase.entity.Supplier;
import com.bizunited.empower.business.purchase.repository.internal.SupplierRepositoryCustom;

import java.lang.String;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * Supplier业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_SupplierRepository")
public interface SupplierRepository
    extends
    JpaRepository<Supplier, String>
    , JpaSpecificationExecutor<Supplier>
    , SupplierRepositoryCustom {

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  @Query("select distinct supplier from Supplier supplier " +
      "left join fetch supplier.products supplier_products" +
      " where supplier.id=:id ")
  Supplier findDetailsById(@Param("id") String id);

  /**
   * 通过租户编码和供应商编码查询供应商信息
   *
   * @param supplierCode
   * @param tenantCode
   * @return
   */
  @Query("from Supplier s where s.supplierCode=:supplierCode and s.tenantCode=:tenantCode")
  Supplier findBySupplierCodeAndTenantCode(@Param("supplierCode") String supplierCode, @Param("tenantCode") String tenantCode);

  /**
   * 通过状态查询供应商信息
   * @param tstatus
   * @return
   */
  List<Supplier> findByTstatusAndTenantCode(@Param("tstatus") Integer tstatus, @Param("tenantCode") String tenantCode);

}