package com.bizunited.empower.business.purchase.repository.internal;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

import com.bizunited.empower.business.purchase.dto.PurchaseOrderConditionDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.empower.business.purchase.entity.PurchaseOrder;
import org.springframework.stereotype.Repository;

/**
 * PurchaseOrder模型的数据层自定义接口实现，可以由程序员根据实际情况完善
 * @author saturn
 */
@Repository("_PurchaseOrderRepositoryImpl")
public class PurchaseOrderRepositoryImpl implements PurchaseOrderRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  @Override
  public Page<PurchaseOrder> queryPage(Pageable pageable, PurchaseOrderConditionDto conditions) {
  StringBuilder hql = new StringBuilder("from PurchaseOrder c where 1=1");
  StringBuilder countHql = new StringBuilder("select count(*) FROM PurchaseOrder c where 1=1");
  StringBuilder condition = new StringBuilder();
  Map<String, Object> parameters = new HashMap<>();
  if (conditions != null) {
    // TODO 这里的代码需要开发人员自行完善——使用JPA
    if(StringUtils.isNotBlank(conditions.getTenantCode())){
      condition.append(" AND c.tenantCode = :tenantCode");
      parameters.put("tenantCode", conditions.getTenantCode());

    }
    // 创建时间(起始)
    if(conditions.getCreateTimeStart() != null) {
      condition.append(" AND c.createTime >= :createTimeStart ");
      parameters.put("createTimeStart", conditions.getCreateTimeStart());
    }
    // 创建时间(截止)
    if(conditions.getCreateTimeEnd() != null) {
      condition.append(" AND c.createTime <= :createTimeEnd ");
      parameters.put("createTimeEnd", conditions.getCreateTimeEnd());
    }
    if(conditions.getPurchaseOrderStatus()!=null){
      condition.append(" AND c.purchaseOrderStatus = :purchaseOrderStatus ");
      parameters.put("purchaseOrderStatus", conditions.getPurchaseOrderStatus());
    }

    if(conditions.getPayStatus()!=null){
      condition.append(" AND c.payStatus = :payStatus ");
      parameters.put("payStatus", conditions.getPayStatus());
    }
    if(StringUtils.isNotBlank(conditions.getKeyword())){
      condition.append(" and (c.purchaseOrderCode like concat('%',:keyword,'%') or c.supplierName like concat('%',:keyword,'%'))");
      parameters.put("keyword", conditions.getKeyword());
    }

  }
  hql.append(condition).append(" order by c.createTime desc");
  countHql.append(condition);
  return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }
}
