package com.bizunited.empower.business.purchase.repository.internal;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.empower.business.purchase.entity.Supplier;
import org.springframework.stereotype.Repository;

/**
 * Supplier模型的数据层自定义接口实现，可以由程序员根据实际情况完善
 * @author saturn
 */
@Repository("_SupplierRepositoryImpl")
public class SupplierRepositoryImpl implements SupplierRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  @Override
  public Page<Supplier> findByConditions(Pageable pageable, Map<String,Object> conditions) {
    StringBuilder hql = new StringBuilder("from Supplier c where 1=1");
    StringBuilder countHql = new StringBuilder("select count(*) FROM Supplier c where 1=1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();
    if (conditions != null) {
      String keyword = (String) conditions.get("keyword");
      String tenantCode = (String) conditions.get("tenantCode");
      if(StringUtils.isNotBlank(tenantCode)) {
        condition.append(" and c.tenantCode = :tenantCode ");
        parameters.put("tenantCode", tenantCode);
      }
      if(StringUtils.isNotBlank(keyword)) {
        condition.append(" and (c.supplierName like concat(:keyword,'%') or c.contanct like concat(:keyword,'%'))");
        parameters.put("keyword", keyword);
      }


    }
    hql.append(condition).append(" order by c.createTime desc");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }
}
