package com.bizunited.empower.business.purchase.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.purchase.entity.PurchaseOrder;
import com.bizunited.empower.business.purchase.entity.PurchaseOrderFile;
import com.bizunited.empower.business.purchase.repository.PurchaseOrderFileRepository;
import com.bizunited.empower.business.purchase.service.PurchaseOrderFileService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * PurchaseOrderFile业务模型的服务层接口实现
 * @author saturn
 */
@Service("PurchaseOrderFileServiceImpl")
public class PurchaseOrderFileServiceImpl implements PurchaseOrderFileService { 

  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private PurchaseOrderFileRepository purchaseOrderFileRepository;
  @Transactional
  @Override
  public PurchaseOrderFile create(PurchaseOrderFile purchaseOrderFile) {
    PurchaseOrderFile current = this.createForm(purchaseOrderFile);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public PurchaseOrderFile createForm(PurchaseOrderFile purchaseOrderFile) {
   /* 
    * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
    * 1、如果当前模型对象不是主模型
    * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
    * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
    * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
    * 2、如果当前模型对象是主业务模型
    *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
    *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
    *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
    * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
    *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
    *   2.3.2、以及验证每个分组的OneToMany明细信息
    * */
    Date now = new Date();
    purchaseOrderFile.setCreateAccount(SecurityUtils.getUserAccount());
    purchaseOrderFile.setCreateTime(now);
    purchaseOrderFile.setModifyAccount(SecurityUtils.getUserAccount());
    purchaseOrderFile.setModifyTime(now);

    this.createValidation(purchaseOrderFile);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    
    this.purchaseOrderFileRepository.save(purchaseOrderFile);
    
    // 返回最终处理的结果，里面带有详细的关联信息
    return purchaseOrderFile;
  }
  /**
   * 在创建一个新的PurchaseOrderFile模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(PurchaseOrderFile purchaseOrderFile) {
    Validate.notNull(purchaseOrderFile, "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(purchaseOrderFile.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    purchaseOrderFile.setId(null);
    Validate.notBlank(purchaseOrderFile.getTenantCode(), "添加信息时，租户编号不能为空！");
    Validate.notBlank(purchaseOrderFile.getRelativePath(), "添加信息时，相对路径不能为空！");
    Validate.notBlank(purchaseOrderFile.getFileName(), "添加信息时，原始文件名不能为空！");
    Validate.notBlank(purchaseOrderFile.getReFileName(), "添加信息时，重命名后的文件名不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(purchaseOrderFile.getExtend1() == null || purchaseOrderFile.getExtend1().length() < 255 , "扩展字段1,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend2() == null || purchaseOrderFile.getExtend2().length() < 255 , "扩展字段2,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend3() == null || purchaseOrderFile.getExtend3().length() < 255 , "扩展字段3,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend4() == null || purchaseOrderFile.getExtend4().length() < 255 , "扩展字段4,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend5() == null || purchaseOrderFile.getExtend5().length() < 255 , "扩展字段5,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend6() == null || purchaseOrderFile.getExtend6().length() < 255 , "扩展字段6,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend7() == null || purchaseOrderFile.getExtend7().length() < 255 , "扩展字段7,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getTenantCode() == null || purchaseOrderFile.getTenantCode().length() < 255 , "租户编号,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getRelativePath() == null || purchaseOrderFile.getRelativePath().length() < 255 , "相对路径,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getFileName() == null || purchaseOrderFile.getFileName().length() < 128 , "原始文件名,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseOrderFile.getReFileName() == null || purchaseOrderFile.getReFileName().length() < 128 , "重命名后的文件名,在进行添加时填入值超过了限定长度(128)，请检查!");
  }
  @Transactional
  @Override
  public PurchaseOrderFile update(PurchaseOrderFile purchaseOrderFile) {
    PurchaseOrderFile current = this.updateForm(purchaseOrderFile);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public PurchaseOrderFile updateForm(PurchaseOrderFile purchaseOrderFile) {
    /* 
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     * 
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    
    this.updateValidation(purchaseOrderFile);
    // ===================基本信息
    String currentId = purchaseOrderFile.getId();
    Optional<PurchaseOrderFile> op_currentPurchaseOrderFile = this.purchaseOrderFileRepository.findById(currentId);
    PurchaseOrderFile currentPurchaseOrderFile = op_currentPurchaseOrderFile.orElse(null);
    currentPurchaseOrderFile = Validate.notNull(currentPurchaseOrderFile,"未发现指定的原始模型对象信");
    // 开始赋值——更新时间与更新人
    Date now = new Date();
    currentPurchaseOrderFile.setModifyAccount(SecurityUtils.getUserAccount());
    currentPurchaseOrderFile.setModifyTime(now);
    // 开始重新赋值——一般属性
    currentPurchaseOrderFile.setExtend1(purchaseOrderFile.getExtend1());
    currentPurchaseOrderFile.setExtend2(purchaseOrderFile.getExtend2());
    currentPurchaseOrderFile.setExtend3(purchaseOrderFile.getExtend3());
    currentPurchaseOrderFile.setExtend4(purchaseOrderFile.getExtend4());
    currentPurchaseOrderFile.setExtend5(purchaseOrderFile.getExtend5());
    currentPurchaseOrderFile.setExtend6(purchaseOrderFile.getExtend6());
    currentPurchaseOrderFile.setExtend7(purchaseOrderFile.getExtend7());
    currentPurchaseOrderFile.setExtend8(purchaseOrderFile.getExtend8());
    currentPurchaseOrderFile.setExtend9(purchaseOrderFile.getExtend9());
    currentPurchaseOrderFile.setExtend10(purchaseOrderFile.getExtend10());
    currentPurchaseOrderFile.setExtend11(purchaseOrderFile.getExtend11());
    currentPurchaseOrderFile.setTenantCode(purchaseOrderFile.getTenantCode());
    currentPurchaseOrderFile.setRelativePath(purchaseOrderFile.getRelativePath());
    currentPurchaseOrderFile.setFileName(purchaseOrderFile.getFileName());
    currentPurchaseOrderFile.setReFileName(purchaseOrderFile.getReFileName());
    currentPurchaseOrderFile.setPurchaseOrder(purchaseOrderFile.getPurchaseOrder());
    
    this.purchaseOrderFileRepository.saveAndFlush(currentPurchaseOrderFile);
    return currentPurchaseOrderFile;
  }
  /**
   * 在更新一个已有的PurchaseOrderFile模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(PurchaseOrderFile purchaseOrderFile) {

    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(purchaseOrderFile.getTenantCode(), "修改信息时，租户编号不能为空！");
    Validate.notBlank(purchaseOrderFile.getRelativePath(), "修改信息时，相对路径不能为空！");
    Validate.notBlank(purchaseOrderFile.getFileName(), "修改信息时，原始文件名不能为空！");
    Validate.notBlank(purchaseOrderFile.getReFileName(), "修改信息时，重命名后的文件名不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(purchaseOrderFile.getExtend1() == null || purchaseOrderFile.getExtend1().length() < 255 , "扩展字段1,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend2() == null || purchaseOrderFile.getExtend2().length() < 255 , "扩展字段2,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend3() == null || purchaseOrderFile.getExtend3().length() < 255 , "扩展字段3,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend4() == null || purchaseOrderFile.getExtend4().length() < 255 , "扩展字段4,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend5() == null || purchaseOrderFile.getExtend5().length() < 255 , "扩展字段5,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend6() == null || purchaseOrderFile.getExtend6().length() < 255 , "扩展字段6,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend7() == null || purchaseOrderFile.getExtend7().length() < 255 , "扩展字段7,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getTenantCode() == null || purchaseOrderFile.getTenantCode().length() < 255 , "租户编号,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getRelativePath() == null || purchaseOrderFile.getRelativePath().length() < 255 , "相对路径,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getFileName() == null || purchaseOrderFile.getFileName().length() < 128 , "原始文件名,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseOrderFile.getReFileName() == null || purchaseOrderFile.getReFileName().length() < 128 , "重命名后的文件名,在进行修改时填入值超过了限定长度(128)，请检查!");
    
    // 关联性判断，关联属性判断，需要满足ManyToOne或者OneToOne，且not null 且是主模型
  } 
  @Override
  public Set<PurchaseOrderFile> findDetailsByPurchaseOrder(String purchaseOrder) {
    if(StringUtils.isBlank(purchaseOrder)) { 
      return Sets.newHashSet();
    }
    return this.purchaseOrderFileRepository.findDetailsByPurchaseOrder(purchaseOrder);
  }
  @Override
  public PurchaseOrderFile findDetailsById(String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.purchaseOrderFileRepository.findDetailsById(id);
  }
  @Override
  public PurchaseOrderFile findById(String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    
    Optional<PurchaseOrderFile> op = purchaseOrderFileRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    PurchaseOrderFile current = this.findById(id);
    if(current != null) { 
      this.purchaseOrderFileRepository.delete(current);
    }
  }

  @Override
  @Transactional
  public void save(Set<PurchaseOrderFile> purchaseOrderFiles, PurchaseOrder purchaseOrder) {
    /**
     * 1.保存数据边界校验
     * 2.工具类拆分数据
     * 3.写入数据库
     */
    this.saveValidation(purchaseOrderFiles,purchaseOrder);
    purchaseOrderFiles = ObjectUtils.defaultIfNull(purchaseOrderFiles, Sets.newHashSet());
    Set<PurchaseOrderFile> deletes = Sets.newHashSet();
    Set<PurchaseOrderFile> updates = Sets.newHashSet();
    Set<PurchaseOrderFile> creates = Sets.newHashSet();
    Map<String,PurchaseOrderFile> purchaseOrderFileMap = purchaseOrderFiles.stream().collect(Collectors.toMap(PurchaseOrderFile::getId, v->v,(v1, v2)->v2));
    Set<PurchaseOrderFile> dbPurchaseOrderFiles = purchaseOrderFileRepository.findByPurchaseOrderId(purchaseOrder.getId());
    nebulaToolkitService.collectionDiscrepancy(purchaseOrderFiles,dbPurchaseOrderFiles,PurchaseOrderFile::getId,deletes,updates,creates);
    //删除数据
    //解决遗留问题:当在同一事物中 先使用delete 方法删除 在使用save方法保存时，
    //jpa 会先执行insert 在执行delete，该方法会产生唯一索引异常，
    // 解决方法为：使用deleteInBatch方法或者delete之后手动调用flush方法
    if(!CollectionUtils.isEmpty(deletes)){
      purchaseOrderFileRepository.deleteInBatch(deletes);
    }
    //更新数据
    for (PurchaseOrderFile update : updates) {
      PurchaseOrderFile supplierProduct = purchaseOrderFileMap.get(update.getId());
      this.basicsUpdate(update,supplierProduct);
      purchaseOrderFileRepository.saveAndFlush(update);
    }
    //新增数据
    Date now = new Date();
    String userAccount = SecurityUtils.getUserAccount();
    for (PurchaseOrderFile create : creates) {
      create.setCreateAccount(userAccount);
      create.setCreateTime(now);
      create.setModifyAccount(userAccount);
      create.setModifyTime(now);
      create.setPurchaseOrder(purchaseOrder);
      create.setTenantCode(TenantUtils.getTenantCode());
      create.setId(null);
      purchaseOrderFileRepository.saveAndFlush(create);
    }
  }

  private void basicsUpdate(PurchaseOrderFile dbPurchaseOrderFile,PurchaseOrderFile purchaseOrderFile){
    // 开始赋值——更新时间与更新人
    Date now = new Date();
    dbPurchaseOrderFile.setModifyAccount(SecurityUtils.getUserAccount());
    dbPurchaseOrderFile.setModifyTime(now);
    // 开始重新赋值——一般属性
    dbPurchaseOrderFile.setExtend1(purchaseOrderFile.getExtend1());
    dbPurchaseOrderFile.setExtend2(purchaseOrderFile.getExtend2());
    dbPurchaseOrderFile.setExtend3(purchaseOrderFile.getExtend3());
    dbPurchaseOrderFile.setExtend4(purchaseOrderFile.getExtend4());
    dbPurchaseOrderFile.setExtend5(purchaseOrderFile.getExtend5());
    dbPurchaseOrderFile.setExtend6(purchaseOrderFile.getExtend6());
    dbPurchaseOrderFile.setExtend7(purchaseOrderFile.getExtend7());
    dbPurchaseOrderFile.setExtend8(purchaseOrderFile.getExtend8());
    dbPurchaseOrderFile.setExtend9(purchaseOrderFile.getExtend9());
    dbPurchaseOrderFile.setExtend10(purchaseOrderFile.getExtend10());
    dbPurchaseOrderFile.setExtend11(purchaseOrderFile.getExtend11());
    dbPurchaseOrderFile.setRelativePath(purchaseOrderFile.getRelativePath());
    dbPurchaseOrderFile.setFileName(purchaseOrderFile.getFileName());
    dbPurchaseOrderFile.setReFileName(purchaseOrderFile.getReFileName());
    dbPurchaseOrderFile.setPurchaseOrder(purchaseOrderFile.getPurchaseOrder());
  }

  /**
   * 基础数据验证
   */
  private void saveValidation(Set<PurchaseOrderFile> purchaseOrderFiles,PurchaseOrder purchaseOrder){
    Validate.notNull(purchaseOrder,"传入的供应商信息不能为空");
    if(CollectionUtils.isEmpty(purchaseOrderFiles)){
      return;
    }
    /**
     * 逐条校验信息
     */
    for (PurchaseOrderFile purchaseOrderFile : purchaseOrderFiles) {
      this.bascicsValidation(purchaseOrderFile);
    }

  }

  /**
   * 基础数据校验
   * @param purchaseOrderFile
   */
  private void bascicsValidation(PurchaseOrderFile purchaseOrderFile){
    Validate.notNull(purchaseOrderFile, "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.notBlank(purchaseOrderFile.getRelativePath(), "添加信息时，相对路径不能为空！");
    Validate.notBlank(purchaseOrderFile.getFileName(), "添加信息时，原始文件名不能为空！");
    Validate.notBlank(purchaseOrderFile.getReFileName(), "添加信息时，重命名后的文件名不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况）
    Validate.isTrue(purchaseOrderFile.getExtend1() == null || purchaseOrderFile.getExtend1().length() < 255 , "扩展字段1,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend2() == null || purchaseOrderFile.getExtend2().length() < 255 , "扩展字段2,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend3() == null || purchaseOrderFile.getExtend3().length() < 255 , "扩展字段3,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend4() == null || purchaseOrderFile.getExtend4().length() < 255 , "扩展字段4,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend5() == null || purchaseOrderFile.getExtend5().length() < 255 , "扩展字段5,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend6() == null || purchaseOrderFile.getExtend6().length() < 255 , "扩展字段6,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getExtend7() == null || purchaseOrderFile.getExtend7().length() < 255 , "扩展字段7,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getRelativePath() == null || purchaseOrderFile.getRelativePath().length() < 255 , "相对路径,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseOrderFile.getFileName() == null || purchaseOrderFile.getFileName().length() < 128 , "原始文件名,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseOrderFile.getReFileName() == null || purchaseOrderFile.getReFileName().length() < 128 , "重命名后的文件名,在进行添加时填入值超过了限定长度(128)，请检查!");
  }


}
