package com.bizunited.empower.business.purchase.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.purchase.entity.PurchaseReturnOrder;
import com.bizunited.empower.business.purchase.entity.PurchaseReturnOrderFile;
import com.bizunited.empower.business.purchase.repository.PurchaseReturnOrderFileRepository;
import com.bizunited.empower.business.purchase.service.PurchaseReturnOrderFileService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * PurchaseReturnOrderFile业务模型的服务层接口实现
 *
 * @author saturn
 */
@Service("PurchaseReturnOrderFileServiceImpl")
public class PurchaseReturnOrderFileServiceImpl implements PurchaseReturnOrderFileService {
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private PurchaseReturnOrderFileRepository purchaseReturnOrderFileRepository;

  @Transactional
  @Override
  public PurchaseReturnOrderFile create(PurchaseReturnOrderFile purchaseReturnOrderFile) {
    PurchaseReturnOrderFile current = this.createForm(purchaseReturnOrderFile);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  }

  @Transactional
  @Override
  public PurchaseReturnOrderFile createForm(PurchaseReturnOrderFile purchaseReturnOrderFile) {
    /*
     * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *   2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    Date now = new Date();
    purchaseReturnOrderFile.setCreateAccount(SecurityUtils.getUserAccount());
    purchaseReturnOrderFile.setCreateTime(now);
    purchaseReturnOrderFile.setModifyAccount(SecurityUtils.getUserAccount());
    purchaseReturnOrderFile.setModifyTime(now);

    this.createValidation(purchaseReturnOrderFile);

    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================

    this.purchaseReturnOrderFileRepository.save(purchaseReturnOrderFile);

    // 返回最终处理的结果，里面带有详细的关联信息
    return purchaseReturnOrderFile;
  }

  /**
   * 在创建一个新的PurchaseReturnOrderFile模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(PurchaseReturnOrderFile purchaseReturnOrderFile) {
    Validate.notNull(purchaseReturnOrderFile, "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(purchaseReturnOrderFile.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    purchaseReturnOrderFile.setId(null);
    Validate.notBlank(purchaseReturnOrderFile.getTenantCode(), "添加信息时，租户编号不能为空！");
    Validate.notBlank(purchaseReturnOrderFile.getRelativePath(), "添加信息时，相对路径不能为空！");
    Validate.notBlank(purchaseReturnOrderFile.getFileName(), "添加信息时，原始文件名不能为空！");
    Validate.notBlank(purchaseReturnOrderFile.getReFileName(), "添加信息时，重命名后的文件名不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(purchaseReturnOrderFile.getExtend1() == null || purchaseReturnOrderFile.getExtend1().length() < 255, "扩展字段1,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend2() == null || purchaseReturnOrderFile.getExtend2().length() < 255, "扩展字段2,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend3() == null || purchaseReturnOrderFile.getExtend3().length() < 255, "扩展字段3,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend4() == null || purchaseReturnOrderFile.getExtend4().length() < 255, "扩展字段4,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend5() == null || purchaseReturnOrderFile.getExtend5().length() < 255, "扩展字段5,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend6() == null || purchaseReturnOrderFile.getExtend6().length() < 255, "扩展字段6,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend7() == null || purchaseReturnOrderFile.getExtend7().length() < 255, "扩展字段7,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getTenantCode() == null || purchaseReturnOrderFile.getTenantCode().length() < 255, "租户编号,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getRelativePath() == null || purchaseReturnOrderFile.getRelativePath().length() < 255, "相对路径,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getFileName() == null || purchaseReturnOrderFile.getFileName().length() < 128, "原始文件名,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getReFileName() == null || purchaseReturnOrderFile.getReFileName().length() < 128, "重命名后的文件名,在进行添加时填入值超过了限定长度(128)，请检查!");
  }

  @Transactional
  @Override
  public PurchaseReturnOrderFile update(PurchaseReturnOrderFile purchaseReturnOrderFile) {
    PurchaseReturnOrderFile current = this.updateForm(purchaseReturnOrderFile);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  }

  @Transactional
  @Override
  public PurchaseReturnOrderFile updateForm(PurchaseReturnOrderFile purchaseReturnOrderFile) {
    /*
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     *
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */

    this.updateValidation(purchaseReturnOrderFile);
    // ===================基本信息
    String currentId = purchaseReturnOrderFile.getId();
    Optional<PurchaseReturnOrderFile> op_currentPurchaseReturnOrderFile = this.purchaseReturnOrderFileRepository.findById(currentId);
    PurchaseReturnOrderFile currentPurchaseReturnOrderFile = op_currentPurchaseReturnOrderFile.orElse(null);
    currentPurchaseReturnOrderFile = Validate.notNull(currentPurchaseReturnOrderFile, "未发现指定的原始模型对象信");
    // 开始赋值——更新时间与更新人
    Date now = new Date();
    currentPurchaseReturnOrderFile.setModifyAccount(SecurityUtils.getUserAccount());
    currentPurchaseReturnOrderFile.setModifyTime(now);
    // 开始重新赋值——一般属性
    currentPurchaseReturnOrderFile.setExtend1(purchaseReturnOrderFile.getExtend1());
    currentPurchaseReturnOrderFile.setExtend2(purchaseReturnOrderFile.getExtend2());
    currentPurchaseReturnOrderFile.setExtend3(purchaseReturnOrderFile.getExtend3());
    currentPurchaseReturnOrderFile.setExtend4(purchaseReturnOrderFile.getExtend4());
    currentPurchaseReturnOrderFile.setExtend5(purchaseReturnOrderFile.getExtend5());
    currentPurchaseReturnOrderFile.setExtend6(purchaseReturnOrderFile.getExtend6());
    currentPurchaseReturnOrderFile.setExtend7(purchaseReturnOrderFile.getExtend7());
    currentPurchaseReturnOrderFile.setExtend8(purchaseReturnOrderFile.getExtend8());
    currentPurchaseReturnOrderFile.setExtend9(purchaseReturnOrderFile.getExtend9());
    currentPurchaseReturnOrderFile.setExtend10(purchaseReturnOrderFile.getExtend10());
    currentPurchaseReturnOrderFile.setExtend11(purchaseReturnOrderFile.getExtend11());
    currentPurchaseReturnOrderFile.setTenantCode(purchaseReturnOrderFile.getTenantCode());
    currentPurchaseReturnOrderFile.setRelativePath(purchaseReturnOrderFile.getRelativePath());
    currentPurchaseReturnOrderFile.setFileName(purchaseReturnOrderFile.getFileName());
    currentPurchaseReturnOrderFile.setReFileName(purchaseReturnOrderFile.getReFileName());
    currentPurchaseReturnOrderFile.setPurchaseReturnOrder(purchaseReturnOrderFile.getPurchaseReturnOrder());

    this.purchaseReturnOrderFileRepository.saveAndFlush(currentPurchaseReturnOrderFile);
    return currentPurchaseReturnOrderFile;
  }

  /**
   * 在更新一个已有的PurchaseReturnOrderFile模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(PurchaseReturnOrderFile purchaseReturnOrderFile) {

    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(purchaseReturnOrderFile.getTenantCode(), "修改信息时，租户编号不能为空！");
    Validate.notBlank(purchaseReturnOrderFile.getRelativePath(), "修改信息时，相对路径不能为空！");
    Validate.notBlank(purchaseReturnOrderFile.getFileName(), "修改信息时，原始文件名不能为空！");
    Validate.notBlank(purchaseReturnOrderFile.getReFileName(), "修改信息时，重命名后的文件名不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(purchaseReturnOrderFile.getExtend1() == null || purchaseReturnOrderFile.getExtend1().length() < 255, "扩展字段1,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend2() == null || purchaseReturnOrderFile.getExtend2().length() < 255, "扩展字段2,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend3() == null || purchaseReturnOrderFile.getExtend3().length() < 255, "扩展字段3,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend4() == null || purchaseReturnOrderFile.getExtend4().length() < 255, "扩展字段4,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend5() == null || purchaseReturnOrderFile.getExtend5().length() < 255, "扩展字段5,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend6() == null || purchaseReturnOrderFile.getExtend6().length() < 255, "扩展字段6,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend7() == null || purchaseReturnOrderFile.getExtend7().length() < 255, "扩展字段7,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getTenantCode() == null || purchaseReturnOrderFile.getTenantCode().length() < 255, "租户编号,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getRelativePath() == null || purchaseReturnOrderFile.getRelativePath().length() < 255, "相对路径,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getFileName() == null || purchaseReturnOrderFile.getFileName().length() < 128, "原始文件名,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getReFileName() == null || purchaseReturnOrderFile.getReFileName().length() < 128, "重命名后的文件名,在进行修改时填入值超过了限定长度(128)，请检查!");

    // 关联性判断，关联属性判断，需要满足ManyToOne或者OneToOne，且not null 且是主模型
  }

  @Override
  public Set<PurchaseReturnOrderFile> findDetailsByPurchaseReturnOrder(String purchaseReturnOrder) {
    if (StringUtils.isBlank(purchaseReturnOrder)) {
      return Sets.newHashSet();
    }
    return this.purchaseReturnOrderFileRepository.findDetailsByPurchaseReturnOrder(purchaseReturnOrder);
  }

  @Override
  public PurchaseReturnOrderFile findDetailsById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.purchaseReturnOrderFileRepository.findDetailsById(id);
  }

  @Override
  public PurchaseReturnOrderFile findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }

    Optional<PurchaseReturnOrderFile> op = purchaseReturnOrderFileRepository.findById(id);
    return op.orElse(null);
  }

  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id, "进行删除时，必须给定主键信息!!");
    PurchaseReturnOrderFile current = this.findById(id);
    if (current != null) {
      this.purchaseReturnOrderFileRepository.delete(current);
    }
  }

  @Override
  @Transactional
  public void save(Set<PurchaseReturnOrderFile> purchaseReturnOrderFiles, PurchaseReturnOrder purchaseReturnOrder) {
    /**
     * 1.保存数据边界校验
     * 2.工具类拆分数据
     * 3.写入数据库
     */
    this.saveValidation(purchaseReturnOrderFiles, purchaseReturnOrder);
    purchaseReturnOrderFiles = ObjectUtils.defaultIfNull(purchaseReturnOrderFiles, Sets.newHashSet());
    Set<PurchaseReturnOrderFile> deletes = Sets.newHashSet();
    Set<PurchaseReturnOrderFile> updates = Sets.newHashSet();
    Set<PurchaseReturnOrderFile> creates = Sets.newHashSet();
    Map<String, PurchaseReturnOrderFile> purchaseReturnOrderFileMap = purchaseReturnOrderFiles.stream().collect(Collectors.toMap(PurchaseReturnOrderFile::getId, v -> v, (v1, v2) -> v2));
    Set<PurchaseReturnOrderFile> dbPurchaseReturnOrderFiles = purchaseReturnOrderFileRepository.findByPurchaseReturnOrderId(purchaseReturnOrder.getId());
    nebulaToolkitService.collectionDiscrepancy(purchaseReturnOrderFiles, dbPurchaseReturnOrderFiles, PurchaseReturnOrderFile::getId, deletes, updates, creates);
    //删除数据
    //解决遗留问题:当在同一事物中 先使用delete 方法删除 在使用save方法保存时，
    //jpa 会先执行insert 在执行delete，该方法会产生唯一索引异常，
    // 解决方法为：使用deleteInBatch方法或者delete之后手动调用flush方法
    if(!CollectionUtils.isEmpty(deletes)){
      purchaseReturnOrderFileRepository.deleteInBatch(deletes);
    }
    //更新数据
    for (PurchaseReturnOrderFile update : updates) {
      PurchaseReturnOrderFile purchaseReturnOrderFile = purchaseReturnOrderFileMap.get(update.getId());
      this.basicsUpdate(update, purchaseReturnOrderFile);
      purchaseReturnOrderFileRepository.saveAndFlush(update);
    }
    //新增数据
    Date now = new Date();
    String userAccount = SecurityUtils.getUserAccount();
    for (PurchaseReturnOrderFile create : creates) {
      create.setCreateAccount(userAccount);
      create.setCreateTime(now);
      create.setModifyAccount(userAccount);
      create.setModifyTime(now);
      create.setPurchaseReturnOrder(purchaseReturnOrder);
      create.setTenantCode(TenantUtils.getTenantCode());
      create.setId(null);
      purchaseReturnOrderFileRepository.saveAndFlush(create);
    }
  }

  /**
   * 保存基础属性校验
   *
   * @param purchaseReturnOrderFiles
   * @param purchaseReturnOrder
   */
  private void saveValidation(Set<PurchaseReturnOrderFile> purchaseReturnOrderFiles, PurchaseReturnOrder purchaseReturnOrder) {
    Validate.notNull(purchaseReturnOrder, "传入的采购退单信息不能为空");
    if (CollectionUtils.isEmpty(purchaseReturnOrderFiles)) {
      return;
    }
    /**
     * 逐条校验信息
     */
    for (PurchaseReturnOrderFile purchaseReturnOrderFile : purchaseReturnOrderFiles) {
      this.bascicsValidation(purchaseReturnOrderFile);
    }

  }

  /**
   * 基础属性校验
   *
   * @param purchaseReturnOrderFile
   */
  private void bascicsValidation(PurchaseReturnOrderFile purchaseReturnOrderFile) {
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(purchaseReturnOrderFile.getRelativePath(), "修改信息时，相对路径不能为空！");
    Validate.notBlank(purchaseReturnOrderFile.getFileName(), "修改信息时，原始文件名不能为空！");
    Validate.notBlank(purchaseReturnOrderFile.getReFileName(), "修改信息时，重命名后的文件名不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(purchaseReturnOrderFile.getExtend1() == null || purchaseReturnOrderFile.getExtend1().length() < 255, "扩展字段1,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend2() == null || purchaseReturnOrderFile.getExtend2().length() < 255, "扩展字段2,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend3() == null || purchaseReturnOrderFile.getExtend3().length() < 255, "扩展字段3,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend4() == null || purchaseReturnOrderFile.getExtend4().length() < 255, "扩展字段4,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend5() == null || purchaseReturnOrderFile.getExtend5().length() < 255, "扩展字段5,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend6() == null || purchaseReturnOrderFile.getExtend6().length() < 255, "扩展字段6,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getExtend7() == null || purchaseReturnOrderFile.getExtend7().length() < 255, "扩展字段7,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getRelativePath() == null || purchaseReturnOrderFile.getRelativePath().length() < 255, "相对路径,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getFileName() == null || purchaseReturnOrderFile.getFileName().length() < 128, "原始文件名,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderFile.getReFileName() == null || purchaseReturnOrderFile.getReFileName().length() < 128, "重命名后的文件名,在进行修改时填入值超过了限定长度(128)，请检查!");
  }

  /**
   * 修改数据赋值
   *
   * @param dbPurchaseReturnOrderFile
   * @param purchaseReturnOrderFile
   */
  private void basicsUpdate(PurchaseReturnOrderFile dbPurchaseReturnOrderFile, PurchaseReturnOrderFile purchaseReturnOrderFile) {
    // 开始赋值——更新时间与更新人
    Date now = new Date();
    dbPurchaseReturnOrderFile.setModifyAccount(SecurityUtils.getUserAccount());
    dbPurchaseReturnOrderFile.setModifyTime(now);
    // 开始重新赋值——一般属性
    dbPurchaseReturnOrderFile.setExtend1(purchaseReturnOrderFile.getExtend1());
    dbPurchaseReturnOrderFile.setExtend2(purchaseReturnOrderFile.getExtend2());
    dbPurchaseReturnOrderFile.setExtend3(purchaseReturnOrderFile.getExtend3());
    dbPurchaseReturnOrderFile.setExtend4(purchaseReturnOrderFile.getExtend4());
    dbPurchaseReturnOrderFile.setExtend5(purchaseReturnOrderFile.getExtend5());
    dbPurchaseReturnOrderFile.setExtend6(purchaseReturnOrderFile.getExtend6());
    dbPurchaseReturnOrderFile.setExtend7(purchaseReturnOrderFile.getExtend7());
    dbPurchaseReturnOrderFile.setExtend8(purchaseReturnOrderFile.getExtend8());
    dbPurchaseReturnOrderFile.setExtend9(purchaseReturnOrderFile.getExtend9());
    dbPurchaseReturnOrderFile.setExtend10(purchaseReturnOrderFile.getExtend10());
    dbPurchaseReturnOrderFile.setExtend11(purchaseReturnOrderFile.getExtend11());
    dbPurchaseReturnOrderFile.setRelativePath(purchaseReturnOrderFile.getRelativePath());
    dbPurchaseReturnOrderFile.setFileName(purchaseReturnOrderFile.getFileName());
    dbPurchaseReturnOrderFile.setReFileName(purchaseReturnOrderFile.getReFileName());
    dbPurchaseReturnOrderFile.setPurchaseReturnOrder(purchaseReturnOrderFile.getPurchaseReturnOrder());

  }


}
