package com.bizunited.empower.business.purchase.service.internal;

import com.bizunited.empower.business.product.entity.Product;
import com.bizunited.empower.business.product.service.ProductService;
import com.bizunited.empower.business.purchase.common.enums.PurchaseReturnOrderStatus;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.purchase.entity.PurchaseReturnOrder;
import com.bizunited.empower.business.purchase.entity.PurchaseReturnOrderProduct;
import com.bizunited.empower.business.purchase.repository.PurchaseReturnOrderProductRepository;
import com.bizunited.empower.business.purchase.service.PurchaseReturnOrderProductService;
import com.bizunited.empower.business.purchase.service.PurchaseReturnOrderService;
import com.bizunited.empower.business.purchase.vo.PurchaseReturnOrderProductVo;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsExpenseVoService;
import com.bizunited.empower.business.warehouse.vo.WarehouseProductsExpenseProductVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * PurchaseReturnOrderProduct业务模型的服务层接口实现
 *
 * @author saturn
 */
@Service("PurchaseReturnOrderProductServiceImpl")
public class PurchaseReturnOrderProductServiceImpl implements PurchaseReturnOrderProductService {
  @Autowired
  private PurchaseReturnOrderService purchaseReturnOrderService;
  @Autowired
  private PurchaseReturnOrderProductRepository purchaseReturnOrderProductRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private WarehouseProductsExpenseVoService warehouseProductsExpenseVoService;
  @Autowired
  private ProductService productService;

  @Transactional
  @Override
  public PurchaseReturnOrderProduct create(PurchaseReturnOrderProduct purchaseReturnOrderProduct) {
    PurchaseReturnOrderProduct current = this.createForm(purchaseReturnOrderProduct);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  }

  @Transactional
  @Override
  public PurchaseReturnOrderProduct createForm(PurchaseReturnOrderProduct purchaseReturnOrderProduct) {
    /*
     * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *   2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    Date now = new Date();
    purchaseReturnOrderProduct.setCreateAccount(SecurityUtils.getUserAccount());
    purchaseReturnOrderProduct.setCreateTime(now);
    purchaseReturnOrderProduct.setModifyAccount(SecurityUtils.getUserAccount());
    purchaseReturnOrderProduct.setModifyTime(now);

    this.createValidation(purchaseReturnOrderProduct);

    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================

    this.purchaseReturnOrderProductRepository.save(purchaseReturnOrderProduct);

    // 返回最终处理的结果，里面带有详细的关联信息
    return purchaseReturnOrderProduct;
  }

  /**
   * 在创建一个新的PurchaseReturnOrderProduct模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(PurchaseReturnOrderProduct purchaseReturnOrderProduct) {
    Validate.notNull(purchaseReturnOrderProduct, "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(purchaseReturnOrderProduct.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    purchaseReturnOrderProduct.setId(null);
    Validate.notBlank(purchaseReturnOrderProduct.getTenantCode(), "添加信息时，租户编号不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductCode(), "添加信息时，商品编码不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductName(), "添加信息时，商品名称不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getMainImagePath(), "添加信息时，主图路径不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductSpecificationCode(), "添加信息时，商品（规格）编码不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductSpecificationName(), "添加信息时，商品（规格）名称不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getUnitCode(), "添加信息时，单位不能为空！");
    Validate.notNull(purchaseReturnOrderProduct.getQuantity(), "添加信息时，退货数量不能为空！");
    Validate.notNull(purchaseReturnOrderProduct.getPrice(), "添加信息时，退货单价不能为空！");
    Validate.notNull(purchaseReturnOrderProduct.getAmount(), "添加信息时，小计不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况） 
    Validate.isTrue(purchaseReturnOrderProduct.getExtend1() == null || purchaseReturnOrderProduct.getExtend1().length() < 255, "扩展字段1,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend2() == null || purchaseReturnOrderProduct.getExtend2().length() < 255, "扩展字段2,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend3() == null || purchaseReturnOrderProduct.getExtend3().length() < 255, "扩展字段3,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend4() == null || purchaseReturnOrderProduct.getExtend4().length() < 255, "扩展字段4,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend5() == null || purchaseReturnOrderProduct.getExtend5().length() < 255, "扩展字段5,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend6() == null || purchaseReturnOrderProduct.getExtend6().length() < 255, "扩展字段6,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend7() == null || purchaseReturnOrderProduct.getExtend7().length() < 255, "扩展字段7,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getTenantCode() == null || purchaseReturnOrderProduct.getTenantCode().length() < 255, "租户编号,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductCode() == null || purchaseReturnOrderProduct.getProductCode().length() < 64, "商品编码,在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductName() == null || purchaseReturnOrderProduct.getProductName().length() < 128, "商品名称,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getMainImagePath() == null || purchaseReturnOrderProduct.getMainImagePath().length() < 255, "主图路径,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getBrandCode() == null || purchaseReturnOrderProduct.getBrandCode().length() < 64, "品牌编码,在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getBrandName() == null || purchaseReturnOrderProduct.getBrandName().length() < 1024, "品牌名称,在进行添加时填入值超过了限定长度(1024)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductSpecificationCode() == null || purchaseReturnOrderProduct.getProductSpecificationCode().length() < 128, "商品（规格）编码,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductSpecificationName() == null || purchaseReturnOrderProduct.getProductSpecificationName().length() < 128, "商品（规格）名称,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getUnitCode() == null || purchaseReturnOrderProduct.getUnitCode().length() < 255, "单位,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getCategoryCode() == null || purchaseReturnOrderProduct.getCategoryCode().length() < 255, "分类编码,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getCategoryName() == null || purchaseReturnOrderProduct.getCategoryName().length() < 255, "分类名称,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getCategoryFlatCode() == null || purchaseReturnOrderProduct.getCategoryFlatCode().length() < 255, "快速编号,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getBarCode() == null || purchaseReturnOrderProduct.getBarCode().length() < 64, "条形码,在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getRemark() == null || purchaseReturnOrderProduct.getRemark().length() < 255, "备注信息,在进行添加时填入值超过了限定长度(255)，请检查!");
  }

  @Transactional
  @Override
  public PurchaseReturnOrderProduct update(PurchaseReturnOrderProduct purchaseReturnOrderProduct) {
    PurchaseReturnOrderProduct current = this.updateForm(purchaseReturnOrderProduct);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  }

  @Transactional
  @Override
  public PurchaseReturnOrderProduct updateForm(PurchaseReturnOrderProduct purchaseReturnOrderProduct) {
    /*
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     *
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */

    this.updateValidation(purchaseReturnOrderProduct);
    // ===================基本信息
    String currentId = purchaseReturnOrderProduct.getId();
    Optional<PurchaseReturnOrderProduct> op_currentPurchaseReturnOrderProduct = this.purchaseReturnOrderProductRepository.findById(currentId);
    PurchaseReturnOrderProduct currentPurchaseReturnOrderProduct = op_currentPurchaseReturnOrderProduct.orElse(null);
    currentPurchaseReturnOrderProduct = Validate.notNull(currentPurchaseReturnOrderProduct, "未发现指定的原始模型对象信");
    // 开始赋值——更新时间与更新人
    Date now = new Date();
    currentPurchaseReturnOrderProduct.setModifyAccount(SecurityUtils.getUserAccount());
    currentPurchaseReturnOrderProduct.setModifyTime(now);
    // 开始重新赋值——一般属性
    currentPurchaseReturnOrderProduct.setExtend1(purchaseReturnOrderProduct.getExtend1());
    currentPurchaseReturnOrderProduct.setExtend2(purchaseReturnOrderProduct.getExtend2());
    currentPurchaseReturnOrderProduct.setExtend3(purchaseReturnOrderProduct.getExtend3());
    currentPurchaseReturnOrderProduct.setExtend4(purchaseReturnOrderProduct.getExtend4());
    currentPurchaseReturnOrderProduct.setExtend5(purchaseReturnOrderProduct.getExtend5());
    currentPurchaseReturnOrderProduct.setExtend6(purchaseReturnOrderProduct.getExtend6());
    currentPurchaseReturnOrderProduct.setExtend7(purchaseReturnOrderProduct.getExtend7());
    currentPurchaseReturnOrderProduct.setExtend8(purchaseReturnOrderProduct.getExtend8());
    currentPurchaseReturnOrderProduct.setExtend9(purchaseReturnOrderProduct.getExtend9());
    currentPurchaseReturnOrderProduct.setExtend10(purchaseReturnOrderProduct.getExtend10());
    currentPurchaseReturnOrderProduct.setExtend11(purchaseReturnOrderProduct.getExtend11());
    currentPurchaseReturnOrderProduct.setTenantCode(purchaseReturnOrderProduct.getTenantCode());
    currentPurchaseReturnOrderProduct.setProductCode(purchaseReturnOrderProduct.getProductCode());
    currentPurchaseReturnOrderProduct.setProductName(purchaseReturnOrderProduct.getProductName());
    currentPurchaseReturnOrderProduct.setMainImagePath(purchaseReturnOrderProduct.getMainImagePath());
    currentPurchaseReturnOrderProduct.setBrandCode(purchaseReturnOrderProduct.getBrandCode());
    currentPurchaseReturnOrderProduct.setBrandName(purchaseReturnOrderProduct.getBrandName());
    currentPurchaseReturnOrderProduct.setProductSpecificationCode(purchaseReturnOrderProduct.getProductSpecificationCode());
    currentPurchaseReturnOrderProduct.setProductSpecificationName(purchaseReturnOrderProduct.getProductSpecificationName());
    currentPurchaseReturnOrderProduct.setUnitCode(purchaseReturnOrderProduct.getUnitCode());
    currentPurchaseReturnOrderProduct.setCategoryCode(purchaseReturnOrderProduct.getCategoryCode());
    currentPurchaseReturnOrderProduct.setCategoryName(purchaseReturnOrderProduct.getCategoryName());
    currentPurchaseReturnOrderProduct.setCategoryFlatCode(purchaseReturnOrderProduct.getCategoryFlatCode());
    currentPurchaseReturnOrderProduct.setBarCode(purchaseReturnOrderProduct.getBarCode());
    currentPurchaseReturnOrderProduct.setQuantity(purchaseReturnOrderProduct.getQuantity());
    currentPurchaseReturnOrderProduct.setPrice(purchaseReturnOrderProduct.getPrice());
    currentPurchaseReturnOrderProduct.setAmount(purchaseReturnOrderProduct.getAmount());
    currentPurchaseReturnOrderProduct.setRemark(purchaseReturnOrderProduct.getRemark());
    currentPurchaseReturnOrderProduct.setPurchaseReturnOrder(purchaseReturnOrderProduct.getPurchaseReturnOrder());

    this.purchaseReturnOrderProductRepository.saveAndFlush(currentPurchaseReturnOrderProduct);
    return currentPurchaseReturnOrderProduct;
  }

  /**
   * 在更新一个已有的PurchaseReturnOrderProduct模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(PurchaseReturnOrderProduct purchaseReturnOrderProduct) {

    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(purchaseReturnOrderProduct.getTenantCode(), "修改信息时，租户编号不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductCode(), "修改信息时，商品编码不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductName(), "修改信息时，商品名称不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getMainImagePath(), "修改信息时，主图路径不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductSpecificationCode(), "修改信息时，商品（规格）编码不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductSpecificationName(), "修改信息时，商品（规格）名称不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getUnitCode(), "修改信息时，单位不能为空！");
    Validate.notNull(purchaseReturnOrderProduct.getQuantity(), "修改信息时，退货数量不能为空！");
    Validate.notNull(purchaseReturnOrderProduct.getPrice(), "修改信息时，退货单价不能为空！");
    Validate.notNull(purchaseReturnOrderProduct.getAmount(), "修改信息时，小计不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(purchaseReturnOrderProduct.getExtend1() == null || purchaseReturnOrderProduct.getExtend1().length() < 255, "扩展字段1,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend2() == null || purchaseReturnOrderProduct.getExtend2().length() < 255, "扩展字段2,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend3() == null || purchaseReturnOrderProduct.getExtend3().length() < 255, "扩展字段3,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend4() == null || purchaseReturnOrderProduct.getExtend4().length() < 255, "扩展字段4,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend5() == null || purchaseReturnOrderProduct.getExtend5().length() < 255, "扩展字段5,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend6() == null || purchaseReturnOrderProduct.getExtend6().length() < 255, "扩展字段6,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend7() == null || purchaseReturnOrderProduct.getExtend7().length() < 255, "扩展字段7,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getTenantCode() == null || purchaseReturnOrderProduct.getTenantCode().length() < 255, "租户编号,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductCode() == null || purchaseReturnOrderProduct.getProductCode().length() < 64, "商品编码,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductName() == null || purchaseReturnOrderProduct.getProductName().length() < 128, "商品名称,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getMainImagePath() == null || purchaseReturnOrderProduct.getMainImagePath().length() < 255, "主图路径,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getBrandCode() == null || purchaseReturnOrderProduct.getBrandCode().length() < 64, "品牌编码,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getBrandName() == null || purchaseReturnOrderProduct.getBrandName().length() < 1024, "品牌名称,在进行修改时填入值超过了限定长度(1024)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductSpecificationCode() == null || purchaseReturnOrderProduct.getProductSpecificationCode().length() < 128, "商品（规格）编码,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductSpecificationName() == null || purchaseReturnOrderProduct.getProductSpecificationName().length() < 128, "商品（规格）名称,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getUnitCode() == null || purchaseReturnOrderProduct.getUnitCode().length() < 255, "单位,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getCategoryCode() == null || purchaseReturnOrderProduct.getCategoryCode().length() < 255, "分类编码,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getCategoryName() == null || purchaseReturnOrderProduct.getCategoryName().length() < 255, "分类名称,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getCategoryFlatCode() == null || purchaseReturnOrderProduct.getCategoryFlatCode().length() < 255, "快速编号,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getBarCode() == null || purchaseReturnOrderProduct.getBarCode().length() < 64, "条形码,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getRemark() == null || purchaseReturnOrderProduct.getRemark().length() < 255, "备注信息,在进行修改时填入值超过了限定长度(255)，请检查!");

    // 关联性判断，关联属性判断，需要满足ManyToOne或者OneToOne，且not null 且是主模型
  }

  @Override
  public Set<PurchaseReturnOrderProduct> findDetailsByPurchaseReturnOrder(String purchaseReturnOrder) {
    if (StringUtils.isBlank(purchaseReturnOrder)) {
      return Sets.newHashSet();
    }
    return this.purchaseReturnOrderProductRepository.findDetailsByPurchaseReturnOrder(purchaseReturnOrder);
  }

  @Override
  public PurchaseReturnOrderProduct findDetailsById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.purchaseReturnOrderProductRepository.findDetailsById(id);
  }

  @Override
  public PurchaseReturnOrderProduct findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }

    Optional<PurchaseReturnOrderProduct> op = purchaseReturnOrderProductRepository.findById(id);
    return op.orElse(null);
  }

  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id, "进行删除时，必须给定主键信息!!");
    PurchaseReturnOrderProduct current = this.findById(id);
    if (current != null) {
      this.purchaseReturnOrderProductRepository.delete(current);
    }
  }

  @Override
  @Transactional
  public void save(Set<PurchaseReturnOrderProduct> purchaseReturnOrderProducts, PurchaseReturnOrder purchaseReturnOrder) {
    /**
     * 1.保存数据边界校验
     * 2.工具类拆分数据
     * 3.写入数据库
     */
    this.saveValidation(purchaseReturnOrderProducts, purchaseReturnOrder);
    purchaseReturnOrderProducts = ObjectUtils.defaultIfNull(purchaseReturnOrderProducts, Sets.newHashSet());
    Set<PurchaseReturnOrderProduct> deletes = Sets.newHashSet();
    Set<PurchaseReturnOrderProduct> updates = Sets.newHashSet();
    Set<PurchaseReturnOrderProduct> creates = Sets.newHashSet();
    Map<String, PurchaseReturnOrderProduct> purchaseReturnOrderProductMap = purchaseReturnOrderProducts.stream().collect(Collectors.toMap(PurchaseReturnOrderProduct::getId, v -> v, (v1, v2) -> v2));
    List<PurchaseReturnOrderProduct> dbPurchaseReturnOrderProducts = purchaseReturnOrderProductRepository.findByOrderId(purchaseReturnOrder.getId());
    nebulaToolkitService.collectionDiscrepancy(purchaseReturnOrderProducts, dbPurchaseReturnOrderProducts, PurchaseReturnOrderProduct::getId, deletes, updates, creates);
    //删除数据
    //解决遗留问题:当在同一事物中 先使用delete 方法删除 在使用save方法保存时，
    //jpa 会先执行insert 在执行delete，该方法会产生唯一索引异常，
    // 解决方法为：使用deleteInBatch方法或者delete之后手动调用flush方法
    if (!CollectionUtils.isEmpty(deletes)) {
      purchaseReturnOrderProductRepository.deleteInBatch(deletes);
    }
    //更新数据
    for (PurchaseReturnOrderProduct update : updates) {
      PurchaseReturnOrderProduct supplierProduct = purchaseReturnOrderProductMap.get(update.getId());
      this.basicsUpdate(update, supplierProduct);
      purchaseReturnOrderProductRepository.saveAndFlush(update);
    }
    //新增数据
    Date now = new Date();
    String userAccount = SecurityUtils.getUserAccount();
    for (PurchaseReturnOrderProduct create : creates) {
      create.setCreateAccount(userAccount);
      create.setCreateTime(now);
      create.setModifyAccount(userAccount);
      create.setModifyTime(now);
      create.setPurchaseReturnOrder(purchaseReturnOrder);
      create.setId(null);
      purchaseReturnOrderProductRepository.saveAndFlush(create);
    }
  }

  private void basicsUpdate(PurchaseReturnOrderProduct dbPurchaseReturnOrderProduct, PurchaseReturnOrderProduct purchaseReturnOrderProduct) {
    Date now = new Date();
    dbPurchaseReturnOrderProduct.setModifyAccount(SecurityUtils.getUserAccount());
    dbPurchaseReturnOrderProduct.setModifyTime(now);
    // 开始重新赋值——一般属性
    dbPurchaseReturnOrderProduct.setExtend1(purchaseReturnOrderProduct.getExtend1());
    dbPurchaseReturnOrderProduct.setExtend2(purchaseReturnOrderProduct.getExtend2());
    dbPurchaseReturnOrderProduct.setExtend3(purchaseReturnOrderProduct.getExtend3());
    dbPurchaseReturnOrderProduct.setExtend4(purchaseReturnOrderProduct.getExtend4());
    dbPurchaseReturnOrderProduct.setExtend5(purchaseReturnOrderProduct.getExtend5());
    dbPurchaseReturnOrderProduct.setExtend6(purchaseReturnOrderProduct.getExtend6());
    dbPurchaseReturnOrderProduct.setExtend7(purchaseReturnOrderProduct.getExtend7());
    dbPurchaseReturnOrderProduct.setExtend8(purchaseReturnOrderProduct.getExtend8());
    dbPurchaseReturnOrderProduct.setExtend9(purchaseReturnOrderProduct.getExtend9());
    dbPurchaseReturnOrderProduct.setExtend10(purchaseReturnOrderProduct.getExtend10());
    dbPurchaseReturnOrderProduct.setExtend11(purchaseReturnOrderProduct.getExtend11());
    dbPurchaseReturnOrderProduct.setTenantCode(purchaseReturnOrderProduct.getTenantCode());
    dbPurchaseReturnOrderProduct.setProductCode(purchaseReturnOrderProduct.getProductCode());
    dbPurchaseReturnOrderProduct.setProductName(purchaseReturnOrderProduct.getProductName());
    dbPurchaseReturnOrderProduct.setMainImagePath(purchaseReturnOrderProduct.getMainImagePath());
    dbPurchaseReturnOrderProduct.setBrandCode(purchaseReturnOrderProduct.getBrandCode());
    dbPurchaseReturnOrderProduct.setBrandName(purchaseReturnOrderProduct.getBrandName());
    dbPurchaseReturnOrderProduct.setProductSpecificationCode(purchaseReturnOrderProduct.getProductSpecificationCode());
    dbPurchaseReturnOrderProduct.setProductSpecificationName(purchaseReturnOrderProduct.getProductSpecificationName());
    dbPurchaseReturnOrderProduct.setUnitCode(purchaseReturnOrderProduct.getUnitCode());
    dbPurchaseReturnOrderProduct.setCategoryCode(purchaseReturnOrderProduct.getCategoryCode());
    dbPurchaseReturnOrderProduct.setCategoryName(purchaseReturnOrderProduct.getCategoryName());
    dbPurchaseReturnOrderProduct.setCategoryFlatCode(purchaseReturnOrderProduct.getCategoryFlatCode());
    dbPurchaseReturnOrderProduct.setBarCode(purchaseReturnOrderProduct.getBarCode());
    dbPurchaseReturnOrderProduct.setQuantity(purchaseReturnOrderProduct.getQuantity());
    dbPurchaseReturnOrderProduct.setPrice(purchaseReturnOrderProduct.getPrice());
    dbPurchaseReturnOrderProduct.setAmount(purchaseReturnOrderProduct.getAmount());
    dbPurchaseReturnOrderProduct.setRemark(purchaseReturnOrderProduct.getRemark());
    dbPurchaseReturnOrderProduct.setPurchaseReturnOrder(purchaseReturnOrderProduct.getPurchaseReturnOrder());


  }

  /**
   * 基础数据保存验证
   *
   * @param purchaseReturnOrderProducts
   * @param purchaseReturnOrder
   */
  private void saveValidation(Set<PurchaseReturnOrderProduct> purchaseReturnOrderProducts, PurchaseReturnOrder purchaseReturnOrder) {
    Validate.notNull(purchaseReturnOrder, "传入的采购退单信息不能为空");
    Validate.notEmpty(purchaseReturnOrderProducts, "采购退单商品信息不能为空");
    /**
     * 逐条校验信息
     */
    for (PurchaseReturnOrderProduct purchaseReturnOrderProduct : purchaseReturnOrderProducts) {
      this.bascicsValidation(purchaseReturnOrderProduct);
    }
  }

  /**
   * 保存基础数据验证
   */
  private void bascicsValidation(PurchaseReturnOrderProduct purchaseReturnOrderProduct) {
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(purchaseReturnOrderProduct.getTenantCode(), "修改信息时，租户编号不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductCode(), "修改信息时，商品编码不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductName(), "修改信息时，商品名称不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getMainImagePath(), "修改信息时，主图路径不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductSpecificationCode(), "修改信息时，商品（规格）编码不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getProductSpecificationName(), "修改信息时，商品（规格）名称不能为空！");
    Validate.notBlank(purchaseReturnOrderProduct.getUnitCode(), "修改信息时，单位不能为空！");
    Validate.notNull(purchaseReturnOrderProduct.getQuantity(), "修改信息时，退货数量不能为空！");
    Validate.notNull(purchaseReturnOrderProduct.getPrice(), "修改信息时，退货单价不能为空！");
    Validate.notNull(purchaseReturnOrderProduct.getAmount(), "修改信息时，小计不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK，且canupdate = true
    Validate.isTrue(purchaseReturnOrderProduct.getExtend1() == null || purchaseReturnOrderProduct.getExtend1().length() < 255, "扩展字段1,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend2() == null || purchaseReturnOrderProduct.getExtend2().length() < 255, "扩展字段2,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend3() == null || purchaseReturnOrderProduct.getExtend3().length() < 255, "扩展字段3,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend4() == null || purchaseReturnOrderProduct.getExtend4().length() < 255, "扩展字段4,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend5() == null || purchaseReturnOrderProduct.getExtend5().length() < 255, "扩展字段5,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend6() == null || purchaseReturnOrderProduct.getExtend6().length() < 255, "扩展字段6,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getExtend7() == null || purchaseReturnOrderProduct.getExtend7().length() < 255, "扩展字段7,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getTenantCode() == null || purchaseReturnOrderProduct.getTenantCode().length() < 255, "租户编号,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductCode() == null || purchaseReturnOrderProduct.getProductCode().length() < 64, "商品编码,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductName() == null || purchaseReturnOrderProduct.getProductName().length() < 128, "商品名称,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getMainImagePath() == null || purchaseReturnOrderProduct.getMainImagePath().length() < 255, "主图路径,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getBrandCode() == null || purchaseReturnOrderProduct.getBrandCode().length() < 64, "品牌编码,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getBrandName() == null || purchaseReturnOrderProduct.getBrandName().length() < 1024, "品牌名称,在进行修改时填入值超过了限定长度(1024)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductSpecificationCode() == null || purchaseReturnOrderProduct.getProductSpecificationCode().length() < 128, "商品（规格）编码,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getProductSpecificationName() == null || purchaseReturnOrderProduct.getProductSpecificationName().length() < 128, "商品（规格）名称,在进行修改时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getUnitCode() == null || purchaseReturnOrderProduct.getUnitCode().length() < 255, "单位,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getCategoryCode() == null || purchaseReturnOrderProduct.getCategoryCode().length() < 255, "分类编码,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getCategoryName() == null || purchaseReturnOrderProduct.getCategoryName().length() < 255, "分类名称,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getCategoryFlatCode() == null || purchaseReturnOrderProduct.getCategoryFlatCode().length() < 255, "快速编号,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getBarCode() == null || purchaseReturnOrderProduct.getBarCode().length() < 64, "条形码,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(purchaseReturnOrderProduct.getRemark() == null || purchaseReturnOrderProduct.getRemark().length() < 255, "备注信息,在进行修改时填入值超过了限定长度(255)，请检查!");

  }


  @Override
  public List<PurchaseReturnOrderProductVo> findDeliveryByOrderId(String orderId) {
    if (StringUtils.isEmpty(orderId)) {
      return Lists.newArrayList();
    }
    List<PurchaseReturnOrderProduct> purchaseReturnOrderProducts = purchaseReturnOrderProductRepository.findByOrderId(orderId);
    if (CollectionUtils.isEmpty(purchaseReturnOrderProducts)) {
      return Lists.newArrayList();
    }
    Set<String> productCodes = purchaseReturnOrderProducts.stream().map(PurchaseReturnOrderProduct::getProductCode).collect(Collectors.toSet());
    List<Product> productList = productService.findByTenantCodeAndProductCodeIn(Lists.newArrayList(productCodes));
    Map<String, Product> productMap = productList.stream().collect(Collectors.toMap(Product::getProductCode, Function.identity()));

    List<PurchaseReturnOrderProductVo> list = Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(purchaseReturnOrderProducts, PurchaseReturnOrderProduct.class, PurchaseReturnOrderProductVo.class, HashSet.class, ArrayList.class));
    Map<String, BigDecimal> deliveryProducts = new HashMap<>();
    PurchaseReturnOrder purchaseReturnOrder = purchaseReturnOrderService.findById(orderId);
    if (purchaseReturnOrder == null) {
      return Lists.newArrayList();
    }
    //如果当前退单已经完成出库，那么直接返回空列表
    if (PurchaseReturnOrderStatus.COMPLETED.getCode().equals(purchaseReturnOrder.getPurchaseReturnOrderStatus())) {
      return Lists.newArrayList();
    }
    List<WarehouseProductsExpenseProductVo> doneExpenses = warehouseProductsExpenseVoService.findPreemptQuantityByRelevanceCode(purchaseReturnOrder.getPurchaseReturnOrderCode());
    if (!CollectionUtils.isEmpty(doneExpenses)) {
      for (WarehouseProductsExpenseProductVo currentExpenseProductItem : doneExpenses) {
        String productSpecificationCode = currentExpenseProductItem.getProductSpecificationCode();
        Validate.notBlank(productSpecificationCode, "从出库单查询到商品规格编号为空的出库明细，请检查订单[%s]对应的出库单", purchaseReturnOrder.getPurchaseReturnOrderCode());
        BigDecimal quantity = currentExpenseProductItem.getQuantity();
        deliveryProducts.merge(productSpecificationCode, quantity, BigDecimal::add);
      }
    }
    //过滤掉已经完成出库的商品信息
    list = list.stream().filter(e -> {
      BigDecimal quantity = deliveryProducts.getOrDefault(e.getProductSpecificationCode(),BigDecimal.ZERO);
      if (quantity.compareTo(e.getQuantity()) == 0) {
        return false;
      }
      return true;
    }).collect(Collectors.toList());
    list.forEach(e -> {
      BigDecimal quantity = deliveryProducts.getOrDefault(e.getProductSpecificationCode(),BigDecimal.ZERO);
      //设置已出库数量
      e.setRemainingQuantity(quantity);
      Product product = productMap.get(e.getProductCode());
      e.setDefaultWarehouseCode(product.getDefaultWarehouseCode());
      e.setWarehouseName(product.getWarehouseName());
    });

    return list;
  }
}
