package com.bizunited.empower.business.purchase.service.notifier;

import com.bizunited.empower.business.product.entity.Product;
import com.bizunited.empower.business.product.service.notifier.ProductEventListener;
import com.bizunited.empower.business.purchase.repository.SupplierProductRepository;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 商品监听实现
 * 当商品信息 删除或者修改时
 * 采购商品需要实现的内容
 * @author lihuan
 */
@Service
public class ProductEventPurchaseListener implements ProductEventListener {

  @Autowired
  private SupplierProductRepository supplierProductRepository;

  @Override
  public String onDelete(Product product) {
    //TODO: 商品删除时，采购商品需要做的修改
    return null;
  }

  @Override
  public String onUpdate(Product product) {
    //TODO: 商品修改时，采购商品需要做的修改
    return null;
  }

  @Override
  public void onUpdateShelfStatus(String productCode, Integer shelfStatus) {
    //上架状态修改时，修改对应的商品的上下架状态
    supplierProductRepository.updateShelfStatusByProductCodeAndTenantCode(productCode, shelfStatus, TenantUtils.getTenantCode());
  }
}
