package com.bizunited.empower.business.purchase.service.notifier;

import com.bizunited.empower.business.payment.entity.SupplierPaymentInfo;
import com.bizunited.empower.business.payment.service.notifier.SupplierPaymentEventListener;
import com.bizunited.empower.business.purchase.common.enums.PurchaseOrderPayStatus;
import com.bizunited.empower.business.purchase.entity.PurchaseOrder;
import com.bizunited.empower.business.purchase.repository.PurchaseOrderRepository;
import com.bizunited.empower.business.purchase.service.PurchaseOrderService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 采购单付款通知
 * @author lihuan
 */
@Service("SupplierPaymentEventForPurchaseOrderListenerImpl")
public class SupplierPaymentEventForPurchaseOrderListenerImpl implements SupplierPaymentEventListener {

  @Autowired
  private PurchaseOrderService purchaseOrderService;
  @Autowired
  private PurchaseOrderRepository purchaseOrderRepository;

  @Override
  public void onPaymentComplete(SupplierPaymentInfo supplierPaymentInfo) {
    /*
     * 当付款单完成付款时，修改当前付款单付款状态为已完成
     * */
    String purchaseOrderCode = supplierPaymentInfo.getAssociatedCode();
    if (StringUtils.isBlank(purchaseOrderCode) || StringUtils.indexOf(purchaseOrderCode, "CG") == -1) {
      return;
    }
    PurchaseOrder purchaseOrder = purchaseOrderService.findByCode(purchaseOrderCode);
    Validate.notNull(purchaseOrder, "当收到付款通知后，未发现对应的采购单信息!!");
    Validate.isTrue(supplierPaymentInfo.getPaymentStatus() != 1, "当收到付款通知后，发现了错误的付款凭证状态，请检查!!");
    purchaseOrder.setPayStatus(PurchaseOrderPayStatus.ACCOUNT_PAID.getCode());
    this.purchaseOrderRepository.save(purchaseOrder);
  }

  @Override
  public void onPaymentCancelled(SupplierPaymentInfo supplierPaymentInfo) {
    /**
     * 取消付款单 暂时不做任何操作
     */
  }
}
