package com.bizunited.empower.business.purchase.service.notifier;

import com.bizunited.empower.business.payment.entity.SupplierReceivableInfo;
import com.bizunited.empower.business.payment.service.notifier.SupplierReceivableEventListener;
import com.bizunited.empower.business.purchase.common.enums.PurchaseReturnOrderRefundStatus;
import com.bizunited.empower.business.purchase.entity.PurchaseReturnOrder;
import com.bizunited.empower.business.purchase.repository.PurchaseReturnOrderRepository;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 采购退单 收款 通知
 * @author lihuan
 */
@Service("SupplierReceivableEventForPurchaseReturnOrderListenerImpl")
public class SupplierReceivableEventForPurchaseReturnOrderListenerImpl implements SupplierReceivableEventListener {

  @Autowired
  private PurchaseReturnOrderRepository purchaseReturnOrderRepository;


  @Override
  public void onReceivableComplete(SupplierReceivableInfo supplierReceivableInfo) {
    /*
     * 当一张收款单 完成收款时，该通知修改退单状态
     * */
    String orderCode = supplierReceivableInfo.getAssociatedCode();
    String tenantCode = TenantUtils.getTenantCode();
    if (StringUtils.isBlank(orderCode) || StringUtils.indexOf(orderCode, "CT") == -1) {
      return;
    }
    PurchaseReturnOrder currentOrderInfo = this.purchaseReturnOrderRepository.findByPurchaseReturnOrderCodeAndTenantCode(orderCode, tenantCode);
    Validate.notNull(currentOrderInfo, "当收到收款通知后，未发现对应的订单信息!!");
    Validate.isTrue(supplierReceivableInfo.getReceivableStatus() != 1, "当收到收款通知后，发现了错误的收款单状态，请检查!!");
    currentOrderInfo.setRefundStatus(PurchaseReturnOrderRefundStatus.REFUNDED.getCode());
    this.purchaseReturnOrderRepository.saveAndFlush(currentOrderInfo);
  }

  @Override
  public void onReceivableCancelled(SupplierReceivableInfo supplierReceivableInfo) {
    /**
     * 取消通知 暂时不做处理
     */
  }
}
