package com.bizunited.empower.business.purchase.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @author lihuan
 */
@ApiModel("采购单商品信息")
public class PurchaseOrderProductVo extends TenantOpVo{


    private static final long serialVersionUID = -5394775593676765296L;
    /**
     * 商品编码
     */
    @ApiModelProperty("商品编码")
    private String productCode;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String productName;


    /**
     * 主图路径
     */
    @ApiModelProperty("主图路径")
    private String mainImagePath;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String brandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String brandName;


    /** 商品（规格）编码 */
    @ApiModelProperty("商品（规格）编码")
    private String productSpecificationCode;

    /** 商品（规格）名称 */
    @ApiModelProperty("商品（规格）名称")
    private String productSpecificationName;


    /** 单位 */
    @ApiModelProperty("单位")
    private String unitCode;

    /** 单位 */
    @ApiModelProperty("单位")
    private String unitName;


    /** 订货参考价 */
    @ApiModelProperty("订货参考价")
    private BigDecimal referencePrice;

    /**
     * 分类编码
     */
    @ApiModelProperty("分类编码")
    private String categoryCode;

    /**
     * 分类名称
     */
    @ApiModelProperty("分类名称")
    private String categoryName;

    /**
     * 分类快速编码
     */
    @ApiModelProperty("快速编号")
    private String categoryFlatCode;

    @ApiModelProperty("条形码")
    private String barCode;


    /**
     * 采购数量
     */
    @ApiModelProperty(" 采购数量")
    private BigDecimal quantity;

    /**
     * 进货单价
     */
    @ApiModelProperty("进货单价")
    private BigDecimal price;

    /**
     * 小计
     */
    @ApiModelProperty("小计")
    private BigDecimal amount;

    /**
     * 待入库数量
     */
    @ApiModelProperty("待入库数量")
    private BigDecimal remainingQuantity;

    /**
     * 仓库编码
     */
    @ApiModelProperty("仓库编码")
    private String warehouseCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String warehouseName;

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getMainImagePath() {
        return mainImagePath;
    }

    public void setMainImagePath(String mainImagePath) {
        this.mainImagePath = mainImagePath;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getProductSpecificationCode() {
        return productSpecificationCode;
    }

    public void setProductSpecificationCode(String productSpecificationCode) {
        this.productSpecificationCode = productSpecificationCode;
    }

    public String getProductSpecificationName() {
        return productSpecificationName;
    }

    public void setProductSpecificationName(String productSpecificationName) {
        this.productSpecificationName = productSpecificationName;
    }

    public String getUnitCode() {
        return unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public BigDecimal getReferencePrice() {
        return referencePrice;
    }

    public void setReferencePrice(BigDecimal referencePrice) {
        this.referencePrice = referencePrice;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryFlatCode() {
        return categoryFlatCode;
    }

    public void setCategoryFlatCode(String categoryFlatCode) {
        this.categoryFlatCode = categoryFlatCode;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getRemainingQuantity() {
        return remainingQuantity;
    }

    public void setRemainingQuantity(BigDecimal remainingQuantity) {
        this.remainingQuantity = remainingQuantity;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }
}
