package com.bizunited.empower.business.purchase.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lihuan
 */
@ApiModel(value = "PurchaseOrderVo", description = "采购订单信息")
public class PurchaseOrderVo extends TenantOpVo {
  private static final long serialVersionUID = -1902545797318299763L;

  /**
   * 采购单编码
   */
  @ApiModelProperty("采购单编码")
  private String purchaseOrderCode;

  /**
   * 收货日期
   */
  @SaturnColumn(description = "收货日期")
  private Date receiptDate;


  /**
   * 供应商编码
   */
  @ApiModelProperty("供应商编码")
  private String supplierCode;


  /**
   * 供应商名称
   */
  @ApiModelProperty("供应商名称")
  private String supplierName;


  /**
   * 业务员编号
   */
  @ApiModelProperty("业务员编号")
  private String salesmanCode;

  /**
   * 业务员名称
   */
  @ApiModelProperty("业务员名称")
  private String salesmanName;


  /**
   * 采购单状态
   */
  @ApiModelProperty(name = "purchaseOrderStatus", value = "采购单状态", required = true)
  private Integer purchaseOrderStatus;

  /**
   * 付款状态
   */
  @ApiModelProperty(name = "payStatus", value = "付款状态", required = true)
  private Integer payStatus;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 商品总额
   */
  @ApiModelProperty("商品总额")
  private BigDecimal totalAmount;

  /**
   * 备注
   */
  @ApiModelProperty("备注信息")
  private String remark;

  public String getPurchaseOrderCode() {
    return purchaseOrderCode;
  }

  public void setPurchaseOrderCode(String purchaseOrderCode) {
    this.purchaseOrderCode = purchaseOrderCode;
  }

  public Date getReceiptDate() {
    return receiptDate;
  }

  public void setReceiptDate(Date receiptDate) {
    this.receiptDate = receiptDate;
  }

  public String getSupplierCode() {
    return supplierCode;
  }

  public void setSupplierCode(String supplierCode) {
    this.supplierCode = supplierCode;
  }

  public String getSupplierName() {
    return supplierName;
  }

  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }

  public String getSalesmanCode() {
    return salesmanCode;
  }

  public void setSalesmanCode(String salesmanCode) {
    this.salesmanCode = salesmanCode;
  }

  public String getSalesmanName() {
    return salesmanName;
  }

  public void setSalesmanName(String salesmanName) {
    this.salesmanName = salesmanName;
  }

  public Integer getPurchaseOrderStatus() {
    return purchaseOrderStatus;
  }

  public void setPurchaseOrderStatus(Integer purchaseOrderStatus) {
    this.purchaseOrderStatus = purchaseOrderStatus;
  }

  public Integer getPayStatus() {
    return payStatus;
  }

  public void setPayStatus(Integer payStatus) {
    this.payStatus = payStatus;
  }

  public String getWarehouseCode() {
    return warehouseCode;
  }

  public void setWarehouseCode(String warehouseCode) {
    this.warehouseCode = warehouseCode;
  }

  public String getWarehouseName() {
    return warehouseName;
  }

  public void setWarehouseName(String warehouseName) {
    this.warehouseName = warehouseName;
  }

  public BigDecimal getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(BigDecimal totalAmount) {
    this.totalAmount = totalAmount;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }
}
