package com.bizunited.empower.business.purchase.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @author lihuan
 */
@ApiModel(value = "PurchaseReturnOrderVo", description = "采购退货单信息")
public class PurchaseReturnOrderVo extends TenantOpVo {
  private static final long serialVersionUID = -1902545797318299763L;

  @ApiModelProperty("退货单编码")
  private String purchaseReturnOrderCode;


  /**
   * 供应商编码
   */
  @ApiModelProperty("供应商编码")
  private String supplierCode;


  /**
   * 供应商名称
   */
  @ApiModelProperty("供应商名称")
  private String supplierName;



  /**
   * 退货单状态
   */
  @ApiModelProperty(name = "purchaseReturnOrderStatus", value = "退货单状态", required = true)
  private Integer purchaseReturnOrderStatus;


  /**
   * 退款状态
   */
  @ApiModelProperty(name = "refundStatus", value = "退款状态", required = true)
  private Integer refundStatus;

  /**
   * 退货总额
   */
  @ApiModelProperty("退货总额")
  private BigDecimal totalAmount;

  /**
   * 备注
   */
  @ApiModelProperty("备注信息")
  private String remark;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  public String getPurchaseReturnOrderCode() {
    return purchaseReturnOrderCode;
  }

  public void setPurchaseReturnOrderCode(String purchaseReturnOrderCode) {
    this.purchaseReturnOrderCode = purchaseReturnOrderCode;
  }

  public String getSupplierCode() {
    return supplierCode;
  }

  public void setSupplierCode(String supplierCode) {
    this.supplierCode = supplierCode;
  }

  public String getSupplierName() {
    return supplierName;
  }

  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }

  public Integer getPurchaseReturnOrderStatus() {
    return purchaseReturnOrderStatus;
  }

  public void setPurchaseReturnOrderStatus(Integer purchaseReturnOrderStatus) {
    this.purchaseReturnOrderStatus = purchaseReturnOrderStatus;
  }

  public Integer getRefundStatus() {
    return refundStatus;
  }

  public void setRefundStatus(Integer refundStatus) {
    this.refundStatus = refundStatus;
  }

  public BigDecimal getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(BigDecimal totalAmount) {
    this.totalAmount = totalAmount;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getWarehouseName() {
    return warehouseName;
  }

  public void setWarehouseName(String warehouseName) {
    this.warehouseName = warehouseName;
  }
}
