package com.bizunited.empower.business.purchase.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;


/**
 * @author lihuan
 */
@ApiModel(value = "SupplierVo",description = "供应商信息")
public class SupplierVo extends TenantOpVo {


    private static final long serialVersionUID = -2860120912495482343L;
    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    private String supplierCode;


    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String supplierName;

    /**
     * 联系人
     */
    @ApiModelProperty("联系人")
    private String contanct;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String mobile;

    /**
     * 供应商地址
     */
    @ApiModelProperty("供应商地址")
    private String supplierAddress;

    /**
     * 开户名称
     */
    @ApiModelProperty("开户名称")
    private String accountName;

    /**
     * 开户银行
     */
    @ApiModelProperty("开户银行")
    private String bankName;

    /**
     * 银行账号
     */
    @ApiModelProperty("银行账号")
    private String bankCode;


    /**
     * 开票抬头
     */
    @ApiModelProperty("开票抬头")
    private String invoiceTitle;

    /**
     * 纳税人识别号
     */

    @ApiModelProperty("纳税人识别号")
    private String taxpayerNumber;


    /**
     * 备注信息
     */
    @ApiModelProperty("备注信息")
    private String remark;

    /**
     * 状态：0(禁用) 1(启用)
     */
    @ApiModelProperty(name = "tstatus", value = "状态：0(禁用) 1(启用)", required = true)
    private Integer tstatus = 1;

    /**
     * 供应商商品信息
     */
    @ApiModelProperty("供应商商品信息")
    private Set<SupplierProductVo> products;


    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getContanct() {
        return contanct;
    }

    public void setContanct(String contanct) {
        this.contanct = contanct;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public String getTaxpayerNumber() {
        return taxpayerNumber;
    }

    public void setTaxpayerNumber(String taxpayerNumber) {
        this.taxpayerNumber = taxpayerNumber;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getTstatus() {
        return tstatus;
    }

    public void setTstatus(Integer tstatus) {
        this.tstatus = tstatus;
    }

    public Set<SupplierProductVo> getProducts() {
        return products;
    }

    public void setProducts(Set<SupplierProductVo> products) {
        this.products = products;
    }
}
