/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.controller.outward;

import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.sales.dto.DistributionRouteDto;
import com.bizunited.empower.business.sales.entity.outward.DistributionRoute;
import com.bizunited.empower.business.sales.service.outward.DistributionRouteService;
import com.bizunited.empower.business.sales.vo.DistributionRouteDetailVo;
import com.bizunited.empower.business.sales.vo.DistributionRouteVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/distributionRoute"})
public class DistributionRouteController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributionRouteController.class);
    @Autowired
    private DistributionRouteService distributionRouteService;

    @ApiOperation(value="\u914d\u9001\u8def\u7ebf\u521b\u5efa")
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody @ApiParam(name="distributionRoute", value="\u914d\u9001\u8def\u7ebf\u521b\u5efa") DistributionRoute distributionRoute) {
        try {
            DistributionRoute current = this.distributionRouteService.create(distributionRoute);
            return this.buildHttpResultW((Object)current, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u914d\u9001\u8def\u7ebf\u66f4\u65b0")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestBody @ApiParam(name="distributionRoute", value="\u914d\u9001\u8def\u7ebf\u66f4\u65b0") DistributionRoute distributionRoute) {
        try {
            DistributionRoute current = this.distributionRouteService.update(distributionRoute);
            return this.buildHttpResultW((Object)current, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952eid\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    public ResponseModel findById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            DistributionRoute current = this.distributionRouteService.findById(id);
            return this.buildHttpResultW((Object)current, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u7801code\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/findByCode"})
    public ResponseModel findByCode(@RequestParam(value="code") @ApiParam(name="code", value="\u7f16\u7801") String code) {
        try {
            DistributionRoute current = this.distributionRouteService.findByCode(code);
            return this.buildHttpResultW((Object)current, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952eid\u8fdb\u884c\u6570\u636e\u7684\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ResponseModel deleteById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            this.distributionRouteService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u4e3b\u952eid\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            DistributionRouteDetailVo result = this.distributionRouteService.findDetailsById(id);
            return this.buildHttpResultW(result, new String[]{"customers"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u4e3b\u952eid\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsByCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByCode(@RequestParam(value="code") @ApiParam(value="\u7f16\u7801") String code) {
        try {
            DistributionRouteDetailVo result = this.distributionRouteService.findDetailsByCode(code);
            return this.buildHttpResultW(result, new String[]{"customers"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET})
    public ResponseModel queryPage(@ApiParam(name="dto", value="\u914d\u9001\u8def\u7ebfdto\u7ed3\u6784\u4f53") DistributionRouteDto dto, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<DistributionRouteVo> results = this.distributionRouteService.queryPage(dto, pageable);
            return this.buildHttpResultW(results, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u914d\u9001\u8def\u7ebf\u72b6\u6001\u53d8\u66f4")
    @PatchMapping(value={"/updateStatusByCode"})
    public ResponseModel updateStatusByCode(@RequestParam(value="code") @ApiParam(value="\u7f16\u7801") String code, @RequestParam(value="tstatus") @ApiParam(value="\u72b6\u6001\u503c\uff1a\u7981\u7528(0),\u542f\u7528(1)") Integer tstatus) {
        try {
            this.distributionRouteService.updateStatusByCode(code, tstatus);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6b63\u5e38\u8def\u7ebf\u4e2d\u542b\u6709\u7684\u5ba2\u6237\u7f16\u7801\uff0c\u7528\u4e8e\uff1a\u5f53\u6709\u6548\u7684\u914d\u9001\u8def\u7ebf\u4e2d\u542b\u6709A\u5ba2\u6237\u65f6\uff0c\u90a3\u4e48\u5728\u67e5\u8be2\u6dfb\u52a0\u5ba2\u6237\u65f6\uff0c\u9700\u8981\u6392\u9664\u6389A\u5ba2\u6237")
    @RequestMapping(value={"/findExistCustomerCodes"}, method={RequestMethod.GET})
    public ResponseModel findExistCustomerCodes() {
        try {
            Set<String> results = this.distributionRouteService.findExistCustomerCodes();
            return this.buildHttpResultW(results, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findCustomerByConditions"})
    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u53c2\u6570\u4e3apage\u548csize\uff0cpage\u4ece0\u5f00\u59cb\uff0csize\u9ed8\u8ba450")
    public ResponseModel findCustomerByConditions(@PageableDefault(value=50, sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable, @RequestParam(required=false) @ApiParam(value="\u72b6\u6001") Boolean enabledState, @RequestParam(required=false) @ApiParam(value="\u5206\u7c7b\u7f16\u7801") String categoryCode, @RequestParam(required=false) @ApiParam(value="\u6392\u9664\u7684\u5ba2\u6237\u7f16\u7801") List<String> customerCodesNot, @RequestParam(required=false) @ApiParam(value="\u7ea7\u522b\u7f16\u7801") String levelCode, @RequestParam(required=false) @ApiParam(value="\u9500\u552e\u533a\u57df\u7f16\u7801") String saleAreaCode, @RequestParam(required=false) @ApiParam(value="\u5173\u8054\u4e1a\u52a1\u5458") String relevanceUser, @RequestParam(required=false) @ApiParam(value="\u5173\u952e\u5b57,\u5ba2\u6237\u540d\u79f0/\u7f16\u7801") String keyword) {
        try {
            HashMap<String, Object> conditions = new HashMap<String, Object>(8);
            conditions.put("enabledState", enabledState);
            conditions.put("keyword", keyword);
            conditions.put("levelCode", levelCode);
            conditions.put("customerCodesNot", customerCodesNot);
            conditions.put("categoryCode", categoryCode);
            conditions.put("saleAreaCode", saleAreaCode);
            conditions.put("relevanceUser", relevanceUser);
            Page<Customer> page = this.distributionRouteService.findCustomerByConditions(pageable, conditions);
            return this.buildHttpResultW(page, new String[]{"customerCategory", "customerLevel", "salesArea", "deliveryInfos"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

