/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.controller.outward;

import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.sales.dto.OutwardPlanDto;
import com.bizunited.empower.business.sales.entity.outward.OutwardPlan;
import com.bizunited.empower.business.sales.service.outward.OutwardPlanService;
import com.bizunited.empower.business.sales.vo.OutwardPlanVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.script.context.InvokeParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/outwardPlan"})
public class OutwardPlanController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutwardPlanController.class);
    private static final String[] DETAIL_PROPS = new String[]{"route", "productMix", "productMix.detail", "planFrequency"};
    @Autowired
    private OutwardPlanService outwardPlanService;

    @ApiOperation(value="\u51fa\u8f66\u8ba1\u5212\u521b\u5efa")
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody @ApiParam(name="outwardPlan", value="\u51fa\u8f66\u8ba1\u5212\u521b\u5efa") OutwardPlan outwardPlan) {
        try {
            OutwardPlan current = this.outwardPlanService.create(outwardPlan);
            return this.buildHttpResultW((Object)current, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u51fa\u8f66\u8ba1\u5212\u66f4\u65b0")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestBody @ApiParam(name="outwardPlan", value="\u51fa\u8f66\u8ba1\u5212\u66f4\u65b0") OutwardPlan outwardPlan) {
        try {
            OutwardPlan current = this.outwardPlanService.update(outwardPlan);
            return this.buildHttpResultW((Object)current, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952eid\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    public ResponseModel findById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            OutwardPlan current = this.outwardPlanService.findById(id);
            return this.buildHttpResultW((Object)current, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952eid\u8fdb\u884c\u6570\u636e\u7684\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ResponseModel deleteById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            this.outwardPlanService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167OutwardPlan\u5b9e\u4f53\u4e2d\u7684\uff08route\uff09\u5173\u8054\u7684 \u914d\u9001\u8def\u7ebf\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsByRoute"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByRoute(@RequestParam(value="route") @ApiParam(value="\u5173\u8054\u7684 \u914d\u9001\u8def\u7ebf") String route) {
        try {
            Set<OutwardPlan> result = this.outwardPlanService.findDetailsByRoute(route);
            return this.buildHttpResultW(result, DETAIL_PROPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167OutwardPlan\u5b9e\u4f53\u4e2d\u7684\uff08productMix\uff09\u5173\u8054\u7684 \u8f66\u9500\u5546\u54c1\u63a8\u8350\u7ec4\u5408\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsByProductMix"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByProductMix(@RequestParam(value="productMix") @ApiParam(value="\u5173\u8054\u7684 \u8f66\u9500\u5546\u54c1\u63a8\u8350\u7ec4\u5408") String productMix) {
        try {
            Set<OutwardPlan> result = this.outwardPlanService.findDetailsByProductMix(productMix);
            return this.buildHttpResultW(result, DETAIL_PROPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167OutwardPlan\u5b9e\u4f53\u4e2d\u7684\uff08id\uff09\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            OutwardPlan result = this.outwardPlanService.findDetailsById(id);
            return this.buildHttpResultW((Object)result, DETAIL_PROPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167OutwardPlan\u5b9e\u4f53\u4e2d\u7684\uff08code\uff09\u7f16\u7801\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsByCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByCode(@RequestParam(value="code") @ApiParam(value="\u7f16\u7801") String code) {
        try {
            OutwardPlan result = this.outwardPlanService.findDetailsByCode(code);
            return this.buildHttpResultW((Object)result, DETAIL_PROPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET})
    public ResponseModel queryPage(@ApiParam(name="dto", value="\u51fa\u8f66\u8ba1\u5212dto\u7ed3\u6784\u4f53") OutwardPlanDto dto, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<OutwardPlanVo> results = this.outwardPlanService.queryPage(dto, pageable);
            return this.buildHttpResultW(results, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e \u8f66\u8f86\u7f16\u7801\u3001\u8def\u7ebf\u7f16\u7801\u3001\u8ba1\u5212\u72b6\u6001\u67e5\u8be2\u7684\u63a5\u53e3")
    @RequestMapping(value={"/findByVehicleCodeAndRouteCodeAndPlanStatus"}, method={RequestMethod.GET})
    public ResponseModel findByVehicleCodeAndRouteCodeAndPlanStatus(@RequestParam(name="vehicleCode") @ApiParam(name="vehicleCode", value="\u8f66\u8f86\u7f16\u7801") String vehicleCode, @RequestParam(name="routeCode") @ApiParam(name="routeCode", value="\u8def\u7ebf\u7f16\u7801") String routeCode, @RequestParam(name="planStatus", required=false) @ApiParam(name="planStatus", value="\u51fa\u8f66\u8ba1\u5212\u72b6\u6001") Integer planStatus) {
        try {
            List<OutwardPlan> results = this.outwardPlanService.findByVehicleCodeAndRouteCodeAndPlanStatus(vehicleCode, routeCode, planStatus);
            return this.buildHttpResultW(results, DETAIL_PROPS);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u51fa\u8f66\u8ba1\u5212\u72b6\u6001\u53d8\u66f4")
    @PatchMapping(value={"/updateStatusByCode"})
    public ResponseModel updateStatusByCode(@RequestParam(value="code") @ApiParam(value="\u7f16\u7801") String code, @RequestParam(value="tstatus") @ApiParam(value="\u72b6\u6001\u503c\uff1a\u7981\u7528(0),\u542f\u7528(1)") Integer tstatus) {
        try {
            this.outwardPlanService.updateStatusByCode(code, tstatus);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u53ef\u6dfb\u52a0\u5546\u54c1")
    @GetMapping(value={"findProductByConditions"})
    public ResponseModel findProductByConditions(@PageableDefault(value=50) Pageable pageable, @RequestParam(required=false) @ApiParam(value="\u8def\u7ebf\u7f16\u53f7") String routeCode, @RequestParam(required=false) @ApiParam(value="\u5546\u54c1\u7f16\u7801/\u5546\u54c1\u540d\u79f0\uff08\u6a21\u7cca\uff09") String productCode, @RequestParam(required=false) @ApiParam(value="\u54c1\u724c\u7f16\u7801") String brandCode, @RequestParam(required=false) @ApiParam(value="\u5206\u7c7b\u7f16\u7801") String categoryCode, @RequestParam(required=false) @ApiParam(value="\u5206\u7c7b\u5feb\u901f\u7f16\u53f7") String categoryFlatCode, @RequestParam(required=false) @ApiParam(value="\u54c1\u724c\u5feb\u901f\u7f16\u53f7") String brandFlatCode, @RequestParam(required=false) @ApiParam(value="\u4ed3\u5e93\u7f16\u53f7") String warehouseCode) {
        try {
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("productCode", productCode);
            map.put("brandCode", brandCode);
            map.put("categoryCode", categoryCode);
            map.put("categoryFlatCode", categoryFlatCode);
            map.put("brandFlatCode", brandFlatCode);
            InvokeParams conditions = new InvokeParams();
            conditions.putInvokeParams(map);
            Page<ProductSpecificationVo> result = this.outwardPlanService.findProductByConditions(warehouseCode, pageable, conditions);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

