/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.controller.vehicle;

import com.bizunited.empower.business.order.dto.AuthorizeDto;
import com.bizunited.empower.business.sales.dto.DistributionTaskDto;
import com.bizunited.empower.business.sales.service.vehicle.DistributionTaskVoService;
import com.bizunited.empower.business.sales.vo.vehicle.DistributionTaskVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/distributionTaskVo"})
public class DistributionTaskVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributionTaskVoController.class);
    @Autowired
    private DistributionTaskVoService distributionTaskVoService;

    @ApiOperation(value="\u6309\u7167distributionTaskVo\u5b9e\u4f53\u4e2d\u7684\uff08id\uff09\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            DistributionTaskVo result = this.distributionTaskVoService.findDetailsById(id);
            return this.buildHttpResultW((Object)result, new String[]{"products", "deliverAttachments"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByConditions"})
    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u53c2\u6570\u4e3apage\u548csize\uff0cpage\u4ece0\u5f00\u59cb\uff0csize\u9ed8\u8ba450")
    public ResponseModel findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u914d\u9001\u4efb\u52a1dto\u7ed3\u6784\u4f53") DistributionTaskDto dto) {
        try {
            Page<DistributionTaskVo> deliverGoodVoPage = this.distributionTaskVoService.findByConditions(pageable, dto);
            return this.buildHttpResultW(deliverGoodVoPage, new String[]{"products", "deliverAttachments"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u5ef6\u8fdf\u914d\u9001")
    @PostMapping(value={"delayed"})
    public ResponseModel delayed(@RequestParam(value="distributionTaskCode") @ApiParam(value="\u914d\u9001\u4efb\u52a1\u7f16\u53f7") String distributionTaskCode) {
        try {
            this.distributionTaskVoService.delayed(distributionTaskCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u91cd\u65b0\u914d\u9001")
    @PostMapping(value={"againDistribution"})
    public ResponseModel againDistribution(@RequestParam(value="distributionTaskCode") @ApiParam(value="\u914d\u9001\u4efb\u52a1\u7f16\u53f7") String distributionTaskCode) {
        try {
            this.distributionTaskVoService.againDistribution(distributionTaskCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u786e\u8ba4\u9001\u8fbe")
    @PostMapping(value={"delivery"})
    public ResponseModel delivery(@RequestParam(value="distributionTaskCode") @ApiParam(value="\u914d\u9001\u4efb\u52a1\u7f16\u53f7") String distributionTaskCode) {
        try {
            this.distributionTaskVoService.delivery(distributionTaskCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u914d\u9001\u4efb\u52a1\u7f16\u53f7\u5f3a\u5236\u6536\u8d27")
    @PostMapping(value={"receivingGood"})
    public ResponseModel receivingGood(@RequestParam(value="distributionTaskCode") @ApiParam(value="\u914d\u9001\u4efb\u52a1\u7f16\u53f7") String distributionTaskCode) {
        try {
            this.distributionTaskVoService.receivingGood(distributionTaskCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u5355\u53f7\u6838\u51c6\u63d0\u4ea4")
    @PatchMapping(value={"handleRelevanceAuthorize"})
    public ResponseModel handleRelevanceAuthorize(@RequestParam(value="vehicleTaskCode") @ApiParam(value="\u51fa\u8f66\u4efb\u52a1\u7f16\u53f7") String vehicleTaskCode, @RequestParam(value="distributionTaskCode") @ApiParam(value="\u914d\u9001\u4efb\u52a1\u7f16\u53f7") String distributionTaskCode, @RequestBody @ApiParam(name="authorizeDto", value="\u6838\u51c6\u5165\u53c2") AuthorizeDto authorizeDto) {
        try {
            this.distributionTaskVoService.handleRelevanceAuthorize(vehicleTaskCode, distributionTaskCode, authorizeDto);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

