/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.controller.vehicle;

import com.bizunited.empower.business.sales.dto.VehiclePickUpLoadDto;
import com.bizunited.empower.business.sales.service.vehicle.VehiclePickUpLoadVoService;
import com.bizunited.empower.business.sales.vo.vehicle.VehiclePickUpLoadVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/vehiclePickUpLoadVo"})
public class VehiclePickUpLoadVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(VehiclePickUpLoadVoController.class);
    @Autowired
    private VehiclePickUpLoadVoService vehiclePickUpLoadVoService;

    @ApiOperation(value="\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    public ResponseModel findById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            VehiclePickUpLoadVo current = this.vehiclePickUpLoadVoService.findDetailsById(id);
            return this.buildHttpResultW((Object)current, new String[]{"vehicleDistributionProductVos", "vehicleSalesProductVos"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByConditions"})
    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u53c2\u6570\u4e3apage\u548csize\uff0cpage\u4ece0\u5f00\u59cb\uff0csize\u9ed8\u8ba450")
    public ResponseModel findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u63d0\u8d27\u88c5\u8f66dto\u7ed3\u6784\u4f53") VehiclePickUpLoadDto dto) {
        try {
            Page<VehiclePickUpLoadVo> vehiclePickUpLoadVos = this.vehiclePickUpLoadVoService.findByConditions(pageable, dto);
            return this.buildHttpResultW(vehiclePickUpLoadVos, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

