/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.controller.vehicle;

import com.bizunited.empower.business.order.dto.OrderInfoConditionDto;
import com.bizunited.empower.business.payment.entity.ReceiptInfo;
import com.bizunited.empower.business.payment.vo.ReceiptInfoVo;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.empower.business.sales.dto.AllowAndExistVehicleProductDto;
import com.bizunited.empower.business.sales.dto.VehicleSalesOrderDto;
import com.bizunited.empower.business.sales.service.vehicle.VehicleSalesOrderVoService;
import com.bizunited.empower.business.sales.vo.vehicle.CurdateStatisticsVo;
import com.bizunited.empower.business.sales.vo.vehicle.IncomeExpenditureDetailsVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleSalesOrderForCopyVo;
import com.bizunited.empower.business.sales.vo.vehicle.VehicleSalesOrderVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/vehicleSalesOrder"})
public class VehicleSalesOrderVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(VehicleSalesOrderVoController.class);
    @Autowired
    private VehicleSalesOrderVoService vehicleSalesOrderVoService;

    @ApiOperation(value="\u6839\u636e\u8f66\u9500\u8ba2\u5355\u7f16\u7801\uff0c\u67e5\u8be2\u8f66\u9500\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/findDetailsByOrderCode"})
    public ResponseModel findDetailsByOrderCode(@RequestParam(value="vehicleOrderCode") @ApiParam(name="vehicleOrderCode", value="\u8f66\u9500\u8ba2\u5355\u7f16\u7801") String vehicleOrderCode) {
        try {
            VehicleSalesOrderVo result = this.vehicleSalesOrderVoService.findDetailsByVehicleOrderCode(vehicleOrderCode);
            return this.buildHttpResultW(result, new String[]{"customerDeliveryInfo", "orderProducts", "orderFiles"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u548c\u8f66\u8f86\u7f16\u7801\uff0c\u83b7\u53d6\u6536\u6b3e\u4fe1\u606f")
    @GetMapping(value={"/findReceiptInfoByTaskCodeAndVehicleCode"})
    public ResponseModel findReceiptInfoByTaskCodeAndVehicleCode(@RequestParam(value="taskCode") @ApiParam(name="taskCode", value="\u8f66\u9500\u4efb\u52a1\u7f16\u7801") String taskCode, @RequestParam(value="vehicleCode") @ApiParam(name="vehicleCode", value="\u8f66\u8f86\u7f16\u7801") String vehicleCode) {
        try {
            Set<ReceiptInfoVo> result = this.vehicleSalesOrderVoService.findReceiptInfoByTaskCodeAndVehicleCode(taskCode, vehicleCode);
            return this.buildHttpResultW(result, new String[]{"receivableAccount", "receivableInfo"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8f66\u9500\u8ba2\u5355\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/findByContions"})
    public ResponseModel findByConditions(@ApiParam(name="dto", value="\u8f66\u9500\u8ba2\u5355dto") OrderInfoConditionDto dto, @RequestParam(required=false) @ApiParam(value="\u51fa\u8f66\u4efb\u52a1\u7f16\u7801") String vehicleTaskCode, @RequestParam(required=false) @ApiParam(value="\u5f00\u59cb\u65f6\u95f4") String startTime, @RequestParam(required=false) @ApiParam(value="\u7ed3\u675f\u65f6\u95f4") String endTime, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<VehicleSalesOrderVo> result = this.vehicleSalesOrderVoService.findByConditions(dto, pageable, vehicleTaskCode, startTime, endTime);
            return this.buildHttpResultW(result, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8f66\u9500\u8ba2\u5355\u590d\u5236")
    @GetMapping(value={"copy"})
    public ResponseModel copy(@RequestParam(name="orderCode") @ApiParam(name="orderCode", value="\u8f66\u9500\u8ba2\u5355\u7f16\u7801") String orderCode, @RequestParam(name="vehicleCode") @ApiParam(name="vehicleCode", value="\u8f66\u8f86\u7f16\u7801") String vehicleCode) {
        try {
            VehicleSalesOrderForCopyVo vehicleSalesOrderForCopyVo = this.vehicleSalesOrderVoService.copy(orderCode, vehicleCode);
            return this.buildHttpResult(vehicleSalesOrderForCopyVo);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8f66\u9500\u8ba2\u5355\u521b\u5efa")
    @PostMapping(value={""})
    public ResponseModel confirm(@RequestBody @ApiParam(name="dto", value="\u8f66\u9500\u8ba2\u5355dto") VehicleSalesOrderDto dto) {
        try {
            this.vehicleSalesOrderVoService.confirm(dto);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8f66\u9500\u8ba2\u5355\u53d6\u6d88")
    @PutMapping(value={"/cancel"})
    public ResponseModel cancel(@RequestParam(name="orderCode") @ApiParam(name="orderCode", value="\u8f66\u9500\u8ba2\u5355\u7f16\u7801") String orderCode) {
        try {
            this.vehicleSalesOrderVoService.cancel(orderCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8f66\u9500\u786e\u8ba4\u4ea4\u8d27")
    @PutMapping(value={"/confirmDelivery"})
    public ResponseModel confirmDelivery(@RequestParam(name="orderCode") @ApiParam(name="orderCode", value="\u8f66\u9500\u8ba2\u5355\u7f16\u7801") String orderCode) {
        try {
            this.vehicleSalesOrderVoService.confirmDelivery(orderCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8f66\u9500\u521b\u5efa\u6536\u6b3e\u5355")
    @PostMapping(value={"/createReceipt"})
    public ResponseModel createReceipt(@RequestBody @ApiParam(name="receiptInfo", value="\u8f66\u9500\u6536\u6b3e\u4fe1\u606f") ReceiptInfo receiptInfo, @RequestParam(name="orderCode") @ApiParam(name="orderCode", value="\u8f66\u9500\u8ba2\u5355\u7f16\u7801") String orderCode) {
        try {
            this.vehicleSalesOrderVoService.createReceipt(receiptInfo, orderCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8f66\u9500\u786e\u8ba4\u6536\u6b3e")
    @PutMapping(value={"/confirmReceipt"})
    public ResponseModel confirmReceipt(@RequestParam(name="receiptCode") @ApiParam(name="receiptCode", value="\u6536\u6b3e\u5355\u7f16\u7801") String receiptCode) {
        try {
            this.vehicleSalesOrderVoService.confirmReceipt(receiptCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8f66\u9500\u786e\u8ba4\u6536\u6b3e(\u591a\u4e2a\u6536\u6b3e\u5355)")
    @PostMapping(value={"/confirmReceipts"})
    public ResponseModel confirmReceipts(@RequestParam(name="receiptCodes") @ApiParam(name="receiptCodes", value="\u6536\u6b3e\u5355\u7f16\u7801(','\u9017\u53f7\u62fc\u63a5)") String receiptCodes) {
        try {
            this.vehicleSalesOrderVoService.confirmReceipts(receiptCodes);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8f66\u9500\u53d6\u6d88\u6536\u6b3e")
    @PutMapping(value={"/cancelReceipt"})
    public ResponseModel cancelReceipt(@RequestParam(name="receiptCode") @ApiParam(name="receiptCode", value="\u6536\u6b3e\u5355\u7f16\u7801") String receiptCode) {
        try {
            this.vehicleSalesOrderVoService.cancelReceipt(receiptCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4eca\u65e5\u8f66\u9500\u7edf\u8ba1\uff1a\u8fd4\u56de\u4eca\u65e5\u8f66\u9500\u8ba2\u5355\u603b\u91d1\u989d\u3001\u4eca\u65e5\u8f66\u9500\u8ba2\u5355\u6570\u3001\u4eca\u65e5\u8f66\u9500\u603b\u6536\u6b3e\u3001\u4eca\u65e5\u8f66\u9500\u5ba2\u5355\u4ef7")
    @GetMapping(value={"/sumAndCountVehicleSalesToday"})
    public ResponseModel sumAndCountVehicleSalesToday() {
        try {
            CurdateStatisticsVo curdateStatisticsVo = this.vehicleSalesOrderVoService.sumAndCountVehicleSalesToday();
            return this.buildHttpResultW(curdateStatisticsVo, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6536\u652f\u660e\u7ec6\u5217\u8868\uff0c\u6309\u7167\u4eba\u5458\u6765\u7edf\u8ba1")
    @GetMapping(value={"/incomeExpenditureDetailsToday"})
    public ResponseModel incomeExpenditureDetailsToday() {
        try {
            IncomeExpenditureDetailsVo incomeExpenditureDetailsVo = this.vehicleSalesOrderVoService.incomeExpenditureDetailsToday();
            return this.buildHttpResultW(incomeExpenditureDetailsVo, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u6761\u4ef6\uff0c\u67e5\u8be2\u5ba2\u6237\u5141\u9500\u4e14\u8f66\u8f86\u5e93\u5b58\u5b58\u5728\u7684\u5546\u54c1\uff0c\u5bf9\u4e8e\u8d60\u54c1\u5c06\u4e0d\u53d7\u5141\u9500\u6e05\u5355\u5f71\u54cd")
    @GetMapping(value={"/findAllowAndExistVehicleProductsByConditions"})
    public ResponseModel findAllowAndExistVehicleProductsByConditions(@ApiParam(name="dto", value="\u53c2\u6570dto") AllowAndExistVehicleProductDto dto, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<ProductVo> vos = this.vehicleSalesOrderVoService.findAllowAndExistVehicleProductsByConditions(dto, pageable);
            return this.buildHttpResult(vos);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u6761\u4ef6\uff0c\u67e5\u8be2\u5ba2\u6237\u5141\u9500\u5546\u54c1\uff0c\u5bf9\u4e8e\u8d60\u54c1\u5c06\u4e0d\u53d7\u5141\u9500\u6e05\u5355\u5f71\u54cd")
    @GetMapping(value={"/findAllowProductsByConditions"})
    public ResponseModel findAllowProductsByConditions(@ApiParam(name="dto", value="\u53c2\u6570dto") AllowAndExistVehicleProductDto dto, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<ProductVo> vos = this.vehicleSalesOrderVoService.findAllowProductsByConditions(dto, pageable);
            return this.buildHttpResult(vos);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u8f66\u8f86\u7f16\u53f7 \u5546\u54c1\u89c4\u683c\u96c6\u5408\u67e5\u8be2\uff1a\u5546\u54c1\uff0c\u54c1\u724c\uff0c\u5206\u7c7b\uff0c\u5177\u4f53\u89c4\u683c \u8d4b\u503c\u8f66\u8f86\u5546\u54c1\u5e93\u5b58")
    @GetMapping(value={"/findBySpecificationCodes"})
    public ResponseModel findBySpecificationCodes(@RequestParam(value="specificationCodes") @ApiParam(name="specificationCodes", value="\u89c4\u683c\u7f16\u7801") List<String> specificationCodes, @RequestParam(value="vehicleCode") @ApiParam(name="vehicleCode", value="\u8f66\u8f86\u7f16\u53f7") String vehicleCode) {
        try {
            List<ProductSpecificationVo> current = this.vehicleSalesOrderVoService.findBySpecificationCodes(specificationCodes, vehicleCode);
            return this.buildHttpResult(current);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u6761\u5f62\u7801\u67e5\u8be2\u89c4\u683c\u4fe1\u606f \u8f66\u9500\u4f7f\u7528\u8d4b\u503c\u8f66\u8f86\u5e93\u5b58")
    @GetMapping(value={"/findByBarCode"})
    public ResponseModel findByBarCode(@RequestParam(value="barCode") @ApiParam(value="\u6761\u5f62\u7801") String barCode, @ApiParam(value="\u5ba2\u6237\u7f16\u7801") @RequestParam(value="customerCode") String customerCode, @ApiParam(name="vehicleCode", value="\u8f66\u8f86\u7f16\u53f7") String vehicleCode) {
        try {
            ProductSpecificationVo result = this.vehicleSalesOrderVoService.findByBarCode(barCode, customerCode, vehicleCode);
            return this.buildHttpResultW(result, new String[]{"product", "product.productBrand", "productUnitSpecificationAndPrices", "productPricings", "productBarCodeInfos", "productUnitSpecificationAndPrices.productUnit"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

