/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.sales.controller.vehicle;

import com.bizunited.empower.business.distribution.vo.DeliverGoodVo;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.sales.entity.vehicle.VehicleTask;
import com.bizunited.empower.business.sales.service.vehicle.VehicleTaskService;
import com.bizunited.empower.business.sales.vo.vehicle.DeliverGoodProductVo;
import com.bizunited.empower.business.sales.vo.vehicle.WarehouseExpenseProductVo;
import com.bizunited.empower.business.vehicle.entity.Vehicle;
import com.bizunited.empower.business.warehouse.entity.WarehouseProductsExpense;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.script.context.InvokeParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/vehicleTask"})
public class VehicleTaskController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(VehicleTaskController.class);
    @Autowired
    private VehicleTaskService vehicleTaskService;

    @ApiOperation(value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efavehicleTask\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9vehicleTask\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u57fa\u4e8e\uff08VehicleTask\uff09\u6a21\u578b\u7684\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684vehicleTaskJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody @ApiParam(name="vehicleTask", value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efavehicleTask\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9vehicleTask\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u57fa\u4e8e\uff08VehicleTask\uff09\u6a21\u578b\u7684\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684vehicleTaskJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") VehicleTask vehicleTask) {
        try {
            VehicleTask current = this.vehicleTaskService.create(vehicleTask);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u57fa\u4e8e\u6a21\u578b\uff08VehicleTask\uff09\u7684\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684vehicleTaskJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestBody @ApiParam(name="vehicleTask", value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u57fa\u4e8e\u6a21\u578b\uff08VehicleTask\uff09\u7684\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684vehicleTaskJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") VehicleTask vehicleTask) {
        try {
            VehicleTask current = this.vehicleTaskService.update(vehicleTask);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    public ResponseModel findById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            VehicleTask current = this.vehicleTaskService.findById(id);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @DeleteMapping(value={"/{id}"})
    public ResponseModel deleteById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            this.vehicleTaskService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167VehicleTask\u5b9e\u4f53\u4e2d\u7684\uff08id\uff09\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            VehicleTask result = this.vehicleTaskService.findDetailsById(id);
            return this.buildHttpResultW((Object)result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u51fa\u8f66\u4efb\u52a1\u7f16\u7801\u67e5\u8be2")
    @RequestMapping(value={"/findByVehicleTaskCode"}, method={RequestMethod.GET})
    public ResponseModel findByVehicleTaskCode(@RequestParam(value="vehicleTaskCode") @ApiParam(value="\u51fa\u8f66\u4efb\u52a1\u7f16\u7801") String vehicleTaskCode) {
        try {
            VehicleTask result = this.vehicleTaskService.findByVehicleTaskCode(vehicleTaskCode);
            return this.buildHttpResultW((Object)result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"confirm"})
    @ApiOperation(value="\u786e\u8ba4\u4efb\u52a1")
    public ResponseModel confirm(@RequestParam(value="vehicleTaskCode") String vehicleTaskCode) {
        try {
            this.vehicleTaskService.confirm(vehicleTaskCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"cancel"})
    @ApiOperation(value="\u53d6\u6d88\u4efb\u52a1")
    public ResponseModel cancel(@RequestParam(value="vehicleTaskCode") String vehicleTaskCode) {
        try {
            this.vehicleTaskService.cancel(vehicleTaskCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"completePick"})
    @ApiOperation(value="\u5b8c\u6210\u62e3\u8d27")
    public ResponseModel completePick(@RequestParam(value="vehicleTaskCode") String vehicleTaskCode) {
        try {
            this.vehicleTaskService.completePick(vehicleTaskCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"deliverGoods"})
    @ApiOperation(value="\u88c5\u8f66\u53d1\u8d27")
    public ResponseModel deliverGoods(@RequestParam(value="vehicleTaskCode") String vehicleTaskCode) {
        try {
            this.vehicleTaskService.deliverGoods(vehicleTaskCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"returnVehicle"})
    @ApiOperation(value="\u6536\u8f66\u5165\u5e93")
    public ResponseModel returnVehicle(@RequestParam(value="vehicleTaskCode") String vehicleTaskCode) {
        try {
            this.vehicleTaskService.returnVehicle(vehicleTaskCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"addDeliverToVehicleTask"})
    @ApiOperation(value="\u5c06\u53d1\u8d27\u5355\u6dfb\u52a0\u5230\u51fa\u8f66\u4efb\u52a1")
    public ResponseModel addDeliverToVehicleTask(@RequestParam(value="deliverGoodCode") String deliverGoodCode, @RequestParam(value="vehicleTaskCode") String vehicleTaskCode) {
        try {
            this.vehicleTaskService.addDeliverToVehicleTask(deliverGoodCode, vehicleTaskCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findVehicleByUserAccount"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u7528\u6237\u5f53\u524d\u6267\u884c\u4e2d\u7684\u51fa\u8f66\u4efb\u52a1\u5173\u8054\u7684\u8f66\u8f86\u4fe1\u606f")
    public ResponseModel findVehicleByUserAccount(@RequestParam(value="userAccount") String userAccount) {
        try {
            List<Vehicle> vehicleList = this.vehicleTaskService.findVehicleByUserAccount(userAccount);
            return this.buildHttpResultW(vehicleList, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findVehicleTaskCodeByVehicleCode"})
    @ApiOperation(value="\u6839\u636e\u8f66\u8f86\u7f16\u53f7\u67e5\u8be2\u6b63\u5728\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u7f16\u53f7")
    public ResponseModel findVehicleTaskCodeByVehicleCode(@RequestParam(value="vehicleCode") String vehicleCode) {
        try {
            VehicleTask vehicleTask = this.vehicleTaskService.findVehicleTaskByDriving(vehicleCode);
            if (null != vehicleTask) {
                return this.buildHttpResultW(vehicleTask.getVehicleTaskCode(), new String[0]);
            }
            return this.buildHttpResultW("", new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u53ef\u6dfb\u52a0\u51fa\u5e93\u5355")
    @GetMapping(value={"findExpenseByConditions"})
    public ResponseModel findExpenseByConditions(@PageableDefault(value=50) Pageable pageable, @RequestParam(required=false) @ApiParam(value="\u8def\u7ebf\u7f16\u53f7") String routeCode, @RequestParam(required=false) @ApiParam(value="\u4ed3\u5e93\u7f16\u7801") String warehouseCode, @RequestParam(required=false) @ApiParam(value="\u51fa\u5e93\u5355\u53f7\uff08\u6a21\u7cca\uff09") String expenseCode) {
        try {
            HashMap<String, String> map = new HashMap<String, String>(3);
            map.put("expenseCode", expenseCode);
            InvokeParams conditions = new InvokeParams();
            conditions.putInvokeParams(map);
            Page<WarehouseProductsExpense> result = this.vehicleTaskService.findExpenseByConditions(routeCode, warehouseCode, pageable, conditions);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u53ef\u6dfb\u52a0\u53d1\u8d27\u5355")
    @GetMapping(value={"findDeliverGoodByConditions"})
    public ResponseModel findDeliverGoodByConditions(@PageableDefault(value=50) Pageable pageable, @RequestParam(required=false) @ApiParam(value="\u8def\u7ebf\u7f16\u53f7") String routeCode, @RequestParam(required=false) @ApiParam(value="\u4ed3\u5e93\u7f16\u7801") String warehouseCode, @RequestParam(required=false) @ApiParam(value="\u53d1\u8d27\u5355\u53f7") String deliverGoodCode) {
        try {
            Page<DeliverGoodVo> result = this.vehicleTaskService.findDeliverGoodByConditions(routeCode, warehouseCode, deliverGoodCode, pageable);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u53ef\u6dfb\u52a0\u5546\u54c1")
    @GetMapping(value={"findProductByConditions"})
    public ResponseModel findProductByConditions(@PageableDefault(value=50) Pageable pageable, @RequestParam(required=false) @ApiParam(value="\u8def\u7ebf\u7f16\u53f7") String routeCode, @RequestParam(required=false) @ApiParam(value="\u5546\u54c1\u7f16\u7801/\u5546\u54c1\u540d\u79f0\uff08\u6a21\u7cca\uff09") String productCode, @RequestParam(required=false) @ApiParam(value="\u54c1\u724c\u7f16\u7801") String brandCode, @RequestParam(required=false) @ApiParam(value="\u5206\u7c7b\u7f16\u7801") String categoryCode, @RequestParam(required=false) @ApiParam(value="\u5206\u7c7b\u5feb\u901f\u7f16\u53f7") String categoryFlatCode, @RequestParam(required=false) @ApiParam(value="\u54c1\u724c\u5feb\u901f\u7f16\u53f7") String brandFlatCode, @RequestParam(required=false) @ApiParam(value="\u4ed3\u5e93\u7f16\u53f7") String warehouseCode) {
        try {
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("productCode", productCode);
            map.put("brandCode", brandCode);
            map.put("categoryCode", categoryCode);
            map.put("categoryFlatCode", categoryFlatCode);
            map.put("brandFlatCode", brandFlatCode);
            InvokeParams conditions = new InvokeParams();
            conditions.putInvokeParams(map);
            Page<ProductSpecificationVo> result = this.vehicleTaskService.findProductByConditions(warehouseCode, pageable, conditions);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u51fa\u5e93\u5355\u7f16\u53f7\u96c6\u5408\uff0c\u67e5\u8be2\u51fa\u5e93\u5355\u96c6\u5408")
    @GetMapping(value={"findByExpenseCodeList"})
    public ResponseModel findByExpenseCodeList(@RequestParam(value="expenseCodeList") @ApiParam(value="\u51fa\u5e93\u5355\u53f7") List<String> expenseCodeList) {
        try {
            List<WarehouseExpenseProductVo> results = this.vehicleTaskService.findByExpenseCodeList(expenseCodeList);
            return this.buildHttpResult(results);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u53d1\u8d27\u5355\u7f16\u53f7\u96c6\u5408\uff0c\u67e5\u8be2\u51fa\u5e93\u5355\u96c6\u5408")
    @GetMapping(value={"findBydeliverGoodCodeList"})
    public ResponseModel findBydeliverGoodCodeList(@RequestParam(value="deliverGoodCodeList") @ApiParam(value="\u53d1\u8d27\u5355\u53f7") List<String> deliverGoodCodeList) {
        try {
            List<DeliverGoodProductVo> results = this.vehicleTaskService.findBydeliverGoodCodeList(deliverGoodCodeList);
            return this.buildHttpResult(results);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

